/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser;

import java.io.IOException;
import java.io.PrintStream;
import org.beanio.BeanIOException;
import org.beanio.BeanReader;
import org.beanio.BeanReaderErrorHandler;
import org.beanio.BeanReaderException;
import org.beanio.BeanReaderIOException;
import org.beanio.MalformedRecordException;
import org.beanio.RecordContext;
import org.beanio.UnexpectedRecordException;
import org.beanio.UnidentifiedRecordException;
import org.beanio.internal.parser.AbortRecordUnmarshalligException;
import org.beanio.internal.parser.Component;
import org.beanio.internal.parser.Selector;
import org.beanio.internal.parser.UnmarshallingContext;

public class BeanReaderImpl
implements BeanReader {
    private UnmarshallingContext context;
    private Selector layout;
    private int lineNumber;
    private String recordName;
    private BeanReaderErrorHandler errorHandler;
    private boolean ignoreUnidentifiedRecords;

    public BeanReaderImpl(UnmarshallingContext context, Selector layout) {
        this.context = context;
        this.layout = layout;
    }

    public Object read() {
        this.ensureOpen();
        while (this.layout != null) {
            try {
                Object bean = this.internalRead();
                if (bean != null) {
                    return bean;
                }
                if (!this.context.isEOF()) continue;
                return null;
            }
            catch (BeanReaderException ex) {
                this.handleError(ex);
                continue;
            }
            catch (BeanIOException ex) {
                BeanReaderException e = (BeanReaderException)new BeanReaderException("Fatal BeanIOException caught", ex).fillInStackTrace();
                this.handleError(e);
                continue;
            }
            break;
        }
        return null;
    }

    private Object internalRead() {
        Selector parser = null;
        try {
            parser = this.nextRecord();
            if (parser == null) {
                Object var2_2 = null;
                return var2_2;
            }
            this.context.prepare(parser.getName(), parser.isRecordGroup());
            try {
                parser.unmarshal(this.context);
            }
            catch (AbortRecordUnmarshalligException abortRecordUnmarshalligException) {
                // empty catch block
            }
            this.context.validate();
            Object object = parser.getValue(this.context);
            return object;
        }
        finally {
            if (parser != null) {
                parser.clearValue(this.context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Selector nextRecord() throws BeanReaderException {
        Selector parser = null;
        this.recordName = null;
        while (true) {
            this.context.nextRecord();
            if (this.context.isEOF()) {
                try {
                    Selector unsatisfied = this.layout.close(this.context);
                    if (unsatisfied != null) {
                        if (unsatisfied.isRecordGroup()) {
                            throw this.context.newUnsatisfiedGroupException(unsatisfied.getName());
                        }
                        throw this.context.newUnsatisfiedRecordException(unsatisfied.getName());
                    }
                    Selector selector = null;
                    return selector;
                }
                finally {
                    this.layout = null;
                    this.lineNumber = -1;
                }
            }
            this.lineNumber = this.context.getLineNumber();
            try {
                parser = this.layout.matchNext(this.context);
            }
            catch (UnexpectedRecordException unexpectedRecordException) {
                // empty catch block
            }
            if (parser != null || !this.ignoreUnidentifiedRecords) break;
            this.context.recordSkipped();
        }
        if (parser == null) {
            parser = this.layout.matchAny(this.context);
            if (parser != null) {
                throw this.context.recordUnexpectedException(parser.getName());
            }
            throw this.context.recordUnidentifiedException();
        }
        this.recordName = parser.getName();
        return parser;
    }

    public int skip(int count) throws BeanReaderIOException, MalformedRecordException, UnidentifiedRecordException, UnexpectedRecordException {
        this.ensureOpen();
        if (this.layout == null) {
            return 0;
        }
        int n = 0;
        while (n < count) {
            Selector node = this.nextRecord();
            if (node == null) {
                return n;
            }
            node.skip(this.context);
            if (node.getProperty() == null) continue;
            ++n;
        }
        return n;
    }

    public void close() throws BeanReaderIOException {
        this.ensureOpen();
        try {
            this.context.getRecordReader().close();
        }
        catch (IOException ex) {
            throw new BeanReaderIOException("Failed to close record reader", ex);
        }
        finally {
            this.context = null;
        }
    }

    public String getRecordName() {
        return this.recordName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getRecordCount() {
        return this.context == null ? 0 : this.context.getRecordCount();
    }

    public RecordContext getRecordContext(int index) {
        if (this.context == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.context.getRecordContext(index);
    }

    public void setErrorHandler(BeanReaderErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private void ensureOpen() {
        if (this.context == null) {
            throw new BeanReaderIOException("Stream closed");
        }
    }

    private void handleError(BeanReaderException ex) {
        if (this.errorHandler == null) {
            throw ex;
        }
        try {
            this.errorHandler.handleError(ex);
        }
        catch (BeanReaderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanReaderException("Exception thrown by error handler", e);
        }
    }

    public void setIgnoreUnidentifiedRecords(boolean ignoreUnidentifiedRecords) {
        this.ignoreUnidentifiedRecords = ignoreUnidentifiedRecords;
    }

    public void debug() {
        this.debug(System.out);
    }

    public void debug(PrintStream out) {
        ((Component)((Object)this.layout)).print(out);
    }
}

