/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.beanio.internal.parser.Aggregation;
import org.beanio.internal.parser.MarshallingContext;
import org.beanio.internal.parser.ObjectUtils;
import org.beanio.internal.parser.Parser;
import org.beanio.internal.parser.ParserLocal;
import org.beanio.internal.parser.ParsingContext;
import org.beanio.internal.parser.UnmarshallingContext;
import org.beanio.internal.parser.Value;
import org.beanio.internal.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionParser
extends Aggregation {
    private Class<? extends Collection<Object>> type;
    private ParserLocal<Object> value = new ParserLocal();

    @Override
    public void clearValue(ParsingContext context) {
        this.value.set(context, null);
    }

    @Override
    public boolean defines(Object value) {
        if (value == null || this.type == null) {
            return false;
        }
        return Collection.class.isAssignableFrom(value.getClass());
    }

    @Override
    public boolean matches(UnmarshallingContext context) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean marshal(MarshallingContext context, Parser delegate, int minOccurs, int maxOccurs) throws IOException {
        context.pushIteration(this);
        try {
            Collection<Object> collection = this.getCollection(context);
            if (collection == null && minOccurs == 0) {
                boolean bl = false;
                return bl;
            }
            int i = 0;
            if (collection != null) {
                for (Object value : collection) {
                    if (i < maxOccurs) {
                        this.setIterationIndex(context, i);
                        delegate.setValue(context, value);
                        delegate.marshal(context);
                        ++i;
                        continue;
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            if (i < minOccurs) {
                delegate.setValue(context, null);
                while (i < minOccurs) {
                    this.setIterationIndex(context, i);
                    delegate.marshal(context);
                    ++i;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            context.popIteration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean unmarshal(UnmarshallingContext context, Parser delegate, int minOccurs, int maxOccurs) {
        Object value;
        Collection<Object> collection = this.lazy ? null : this.createCollection();
        boolean invalid = false;
        int count = 0;
        try {
            context.pushIteration(this);
            Object fieldValue = null;
            for (int i = 0; i < maxOccurs; ++i) {
                this.setIterationIndex(context, i);
                boolean found = delegate.unmarshal(context);
                if (!found) {
                    delegate.clearValue(context);
                    break;
                }
                fieldValue = delegate.getValue(context);
                if (fieldValue == Value.INVALID) {
                    invalid = true;
                } else if (fieldValue != Value.MISSING && (!this.lazy || StringUtil.hasValue(fieldValue))) {
                    if (collection == null) {
                        collection = this.createCollection();
                    }
                    collection.add(fieldValue);
                }
                delegate.clearValue(context);
                ++count;
            }
        }
        finally {
            context.popIteration();
        }
        if (count < minOccurs) {
            context.addFieldError(this.getName(), null, "minOccurs", minOccurs, maxOccurs);
            value = Value.INVALID;
        } else {
            value = invalid ? Value.INVALID : collection;
        }
        this.value.set(context, value);
        return value == Value.INVALID || count > 0;
    }

    @Override
    public boolean isProperty() {
        return this.type != null;
    }

    protected boolean isInvalid(ParsingContext context) {
        return this.value.get(context) == Value.INVALID;
    }

    protected Collection<Object> getCollection(ParsingContext context) {
        Object value = this.value.get(context);
        if (value == Value.INVALID) {
            return null;
        }
        return (Collection)value;
    }

    @Override
    protected int length(Object value) {
        Collection collection = (Collection)value;
        return collection != null ? collection.size() : 0;
    }

    @Override
    public void setType(Class<?> collectionType) {
        this.type = collectionType;
    }

    public Class<? extends Collection<Object>> getType() {
        return this.type;
    }

    @Override
    public Object createValue(ParsingContext context) {
        Collection<Object> value = this.value.get(context);
        if (value == null) {
            value = this.createCollection();
            this.value.set(context, value);
        }
        return this.getValue(context);
    }

    @Override
    public Object getValue(ParsingContext context) {
        Object value = this.value.get(context);
        return value == null ? Value.MISSING : value;
    }

    @Override
    public void setValue(ParsingContext context, Object value) {
        if (value != null && ((Collection)value).isEmpty()) {
            value = null;
        }
        this.value.set(context, value);
        super.setValue(context, value);
    }

    protected Collection<Object> createCollection() {
        return ObjectUtils.newInstance(this.type);
    }

    @Override
    public int type() {
        return 5;
    }

    @Override
    public int getIterationSize() {
        return this.getSize();
    }

    @Override
    public void registerLocals(Set<ParserLocal<? extends Object>> locals) {
        if (locals.add(this.value)) {
            super.registerLocals(locals);
        }
    }

    @Override
    public boolean hasContent(ParsingContext context) {
        Collection<Object> collection = this.getCollection(context);
        return collection != null && collection.size() > 0;
    }

    @Override
    protected void toParamString(StringBuilder s) {
        super.toParamString(s);
        if (this.type != null) {
            s.append(", type=").append(this.type.getSimpleName());
        }
    }
}

