/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser.format.flat;

import org.beanio.internal.parser.MarshallingContext;
import org.beanio.internal.parser.UnmarshallingContext;
import org.beanio.internal.parser.Value;
import org.beanio.internal.parser.format.FieldPadding;
import org.beanio.internal.parser.format.flat.FlatFieldFormat;
import org.beanio.internal.util.DebugUtil;

public abstract class FlatFieldFormatSupport
implements FlatFieldFormat {
    private String name;
    private int position;
    private int until = 0;
    private boolean lazy = false;
    private FieldPadding padding = null;

    public boolean insertValue(MarshallingContext context, Object value) {
        return false;
    }

    public void insertField(MarshallingContext context, String text) {
        boolean commit;
        boolean bl = commit = text != null || !this.isLazy();
        if (this.padding != null) {
            text = this.padding.pad(text);
        } else if (text == null) {
            text = "";
        }
        this.insertFieldText(context, text, commit);
    }

    protected abstract void insertFieldText(MarshallingContext var1, String var2, boolean var3);

    public String extract(UnmarshallingContext context, boolean reporting) {
        String text = this.extractFieldText(context, reporting);
        if (this.padding != null) {
            if (text == null) {
                return null;
            }
            if (text.length() == 0) {
                return "";
            }
            if (text.length() != this.padding.getLength()) {
                if (reporting) {
                    context.addFieldError(this.name, text, "length", this.padding.getLength());
                }
                return Value.INVALID;
            }
            return this.padding.unpad(text);
        }
        return text;
    }

    protected abstract String extractFieldText(UnmarshallingContext var1, boolean var2);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getUntil() {
        return this.until;
    }

    public void setUntil(int until) {
        this.until = until;
    }

    public int getSize() {
        return 1;
    }

    public boolean isNillable() {
        return false;
    }

    public FieldPadding getPadding() {
        return this.padding;
    }

    public void setPadding(FieldPadding padding) {
        this.padding = padding;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[at=" + this.position + (this.until != 0 ? ", until=" + this.until : "") + ", " + DebugUtil.formatOption("optional", this.lazy) + DebugUtil.formatPadding(this.padding) + "]";
    }
}

