/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser.format.json;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.beanio.internal.parser.MarshallingContext;
import org.beanio.internal.parser.format.json.JsonNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonMarshallingContext
extends MarshallingContext {
    private Object[] valueStack;
    private char[] typeStack;
    private int depth = -1;

    public JsonMarshallingContext(int maxDepth) {
        this.valueStack = new Object[maxDepth];
        this.typeStack = new char[maxDepth];
    }

    @Override
    protected Object getRecordObject() {
        return this.depth < 0 ? null : this.valueStack[0];
    }

    @Override
    public void clear() {
        super.clear();
        this.depth = -1;
    }

    public void push(JsonNode type) {
        Cloneable value = type.getJsonType() == 'O' ? new LinkedHashMap() : new ArrayList();
        this.put(type, value);
        ++this.depth;
        this.valueStack[this.depth] = value;
        this.typeStack[this.depth] = type.getJsonType();
    }

    public void pop() {
        --this.depth;
    }

    public void put(JsonNode type, Object value) {
        if (this.depth < 0) {
            this.depth = 0;
            this.valueStack[this.depth] = new LinkedHashMap();
            this.typeStack[this.depth] = 79;
        }
        if (type.isJsonArray()) {
            List<Object> list;
            if (this.type() == 'A') {
                int index = type.getJsonArrayIndex();
                if (index < this.list().size()) {
                    list = (List)this.list().get(index);
                } else {
                    list = new ArrayList<Object>();
                    this.list().add(list);
                }
            } else {
                list = (ArrayList<Object>)this.map().get(type.getJsonName());
                if (list == null) {
                    list = new ArrayList();
                    this.map().put(type.getJsonName(), list);
                }
            }
            list.add(value);
        } else {
            switch (this.type()) {
                case 'A': {
                    this.list().add(value);
                    break;
                }
                case 'O': {
                    this.map().put(type.getJsonName(), value);
                }
            }
        }
    }

    private Map<String, Object> map() {
        return (Map)this.valueStack[this.depth];
    }

    private List<Object> list() {
        return (List)this.valueStack[this.depth];
    }

    private char type() {
        return this.typeStack[this.depth];
    }
}

