/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser.format.xml;

import org.beanio.internal.parser.FieldFormat;
import org.beanio.internal.parser.MarshallingContext;
import org.beanio.internal.parser.UnmarshallingContext;
import org.beanio.internal.parser.Value;
import org.beanio.internal.parser.format.FieldPadding;
import org.beanio.internal.parser.format.xml.XmlMarshallingContext;
import org.beanio.internal.parser.format.xml.XmlNode;
import org.beanio.internal.parser.format.xml.XmlUnmarshallingContext;
import org.beanio.internal.util.DebugUtil;

public abstract class XmlFieldFormat
implements FieldFormat,
XmlNode {
    private String name;
    private boolean lazy;
    private FieldPadding padding;

    public boolean insertValue(MarshallingContext context, Object value) {
        return false;
    }

    public void insertField(MarshallingContext context, String fieldText) {
        XmlMarshallingContext ctx = (XmlMarshallingContext)context;
        if (this.padding != null && fieldText != null) {
            fieldText = this.padding.pad(fieldText);
        }
        this.insertText(ctx, fieldText);
    }

    protected abstract void insertText(XmlMarshallingContext var1, String var2);

    public String extract(UnmarshallingContext context, boolean reportErrors) {
        XmlUnmarshallingContext ctx = (XmlUnmarshallingContext)context;
        String fieldText = this.extractText(ctx);
        ctx.setFieldText(this.getName(), fieldText == Value.NIL ? null : fieldText);
        if (this.padding != null && fieldText != null) {
            int length = fieldText.length();
            if (length == 0) {
                return "";
            }
            if (length != this.padding.getLength()) {
                if (reportErrors) {
                    context.addFieldError(this.getName(), fieldText, "length", this.padding.getLength());
                }
                fieldText = Value.INVALID;
            } else {
                fieldText = this.padding.unpad(fieldText);
            }
        }
        return fieldText;
    }

    protected abstract String extractText(XmlUnmarshallingContext var1);

    public int getSize() {
        return 1;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public FieldPadding getPadding() {
        return this.padding;
    }

    public void setPadding(FieldPadding padding) {
        this.padding = padding;
    }

    protected void toParamString(StringBuilder s) {
        s.append(DebugUtil.formatOption("optional", this.lazy));
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.getClass().getSimpleName());
        s.append("[");
        this.toParamString(s);
        s.append("]");
        return s.toString();
    }
}

