/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.util;

import java.util.Properties;
import org.beanio.internal.util.Settings;

public final class StringUtil {
    protected static final boolean LAZY_IF_EMPTY = Settings.getInstance().getBoolean("org.beanio.lazyIfEmpty");

    private StringUtil() {
    }

    public static boolean hasValue(Object obj) {
        if (obj == null) {
            return false;
        }
        return !LAZY_IF_EMPTY || !"".equals(obj);
    }

    public static String doPropertySubstitution(String text, final Properties properties) throws IllegalArgumentException {
        return StringUtil.doPropertySubstitution(text, new PropertySource(){

            public String getProperty(String key) {
                return properties != null ? properties.getProperty(key) : null;
            }
        });
    }

    public static String doPropertySubstitution(String text, PropertySource properties) throws IllegalArgumentException {
        if (text == null || text.length() < 3) {
            return text;
        }
        int i = text.indexOf(36);
        if (i < 0) {
            return text;
        }
        StringBuilder s = null;
        int state = 1;
        int keyBegin = i++;
        int valueBegin = 0;
        char[] cs = text.toCharArray();
        int j = cs.length;
        while (i < j) {
            char c = cs[i];
            switch (state) {
                case 0: {
                    if (c == '$') {
                        keyBegin = i;
                        valueBegin = 0;
                        state = 1;
                        break;
                    }
                    if (s == null) break;
                    s.append(c);
                    break;
                }
                case 1: {
                    if (c == '{') {
                        state = 2;
                        break;
                    }
                    if (s != null) {
                        s.append('$').append(c);
                    }
                    state = 0;
                    break;
                }
                case 2: {
                    if (c == '}') {
                        int length = valueBegin > 0 ? valueBegin - keyBegin - 2 : i - keyBegin - 2;
                        String key = new String(cs, keyBegin + 2, length);
                        String value = null;
                        if (properties != null) {
                            value = properties.getProperty(key);
                        }
                        if (value == null && valueBegin > 0) {
                            value = new String(cs, valueBegin + 1, i - valueBegin - 1);
                        }
                        if (value == null) {
                            throw new IllegalArgumentException("Unresovled property '" + key + "'");
                        }
                        if (s == null) {
                            s = new StringBuilder(new String(cs, 0, keyBegin));
                        }
                        s.append(value);
                        state = 0;
                        break;
                    }
                    if (valueBegin != 0 || c != ',') break;
                    valueBegin = i;
                }
            }
            ++i;
        }
        if (s != null) {
            if (state > 0) {
                s.append(new String(cs, keyBegin, cs.length - keyBegin));
            }
            return s.toString();
        }
        return text;
    }

    public static interface PropertySource {
        public String getProperty(String var1);
    }
}

