/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.spring;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beanio.BeanWriter;
import org.beanio.BeanWriterException;
import org.beanio.BeanWriterIOException;
import org.beanio.StreamFactory;
import org.beanio.internal.util.IOUtil;
import org.beanio.internal.util.StatefulWriter;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.WriteFailedException;
import org.springframework.batch.item.WriterNotOpenException;
import org.springframework.batch.item.file.FlatFileHeaderCallback;
import org.springframework.batch.item.file.ResourceAwareItemWriterItemStream;
import org.springframework.batch.item.util.ExecutionContextUserSupport;
import org.springframework.batch.support.transaction.TransactionAwareBufferedWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanIOFlatFileItemWriter<T>
implements ItemStream,
ItemWriter<T>,
ResourceAwareItemWriterItemStream<T>,
InitializingBean {
    private static final String DEFAULT_CHARSET = Charset.defaultCharset().name();
    private static final String DEFAULT_LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String RESTART_KEY = "current.count";
    private static final String WRITER_STATE_NAMESPACE = "bw";
    private StreamFactory streamFactory;
    private Resource streamMapping;
    private String streamName;
    private Resource resource;
    private boolean saveState = true;
    private boolean append = false;
    private boolean shouldDeleteIfExists = true;
    private boolean shouldDeleteIfEmpty = false;
    private boolean transactional = true;
    private String encoding = DEFAULT_CHARSET;
    private String lineSeparator = DEFAULT_LINE_SEPARATOR;
    private FlatFileHeaderCallback headerCallback;
    private ExecutionContextUserSupport ecSupport = new ExecutionContextUserSupport();
    private Stream stream;

    public BeanIOFlatFileItemWriter() {
        this.setName(ClassUtils.getShortName(BeanIOFlatFileItemWriter.class));
    }

    public void afterPropertiesSet() throws Exception {
        this.initializeStreamFactory();
        if (this.append) {
            this.shouldDeleteIfExists = false;
        }
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        if (this.stream != null) {
            return;
        }
        Assert.notNull((Object)this.resource, (String)"The resource must be set");
        this.stream = new Stream();
        this.stream.open(executionContext);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        if (this.stream == null) {
            throw new ItemStreamException("ItemStream not open or already closed.");
        }
        if (this.saveState) {
            this.stream.update(executionContext);
        }
    }

    public void close() throws ItemStreamException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    public void write(List<? extends T> items) throws Exception {
        if (this.stream == null) {
            throw new WriterNotOpenException("Writer must be open before it can be written to");
        }
        this.stream.write(items);
    }

    public void setStreamFactory(StreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }

    public void setStreamMapping(Resource streamMapping) {
        this.streamMapping = streamMapping;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected void initializeStreamFactory() throws Exception {
        if (this.streamFactory == null) {
            this.streamFactory = StreamFactory.newInstance();
        }
        if (!this.streamFactory.isMapped(this.streamName) && this.streamMapping != null) {
            InputStream in = this.streamMapping.getInputStream();
            try {
                this.streamFactory.load(in);
            }
            finally {
                IOUtil.closeQuietly(in);
            }
        }
        if (!this.streamFactory.isMapped(this.streamName)) {
            throw new IllegalStateException("No mapping configuration for stream '" + this.streamName + "'");
        }
    }

    public void setAppendAllowed(boolean append) {
        this.append = append;
        this.shouldDeleteIfExists = false;
    }

    public void setShouldDeleteIfExists(boolean shouldDeleteIfExists) {
        this.shouldDeleteIfExists = shouldDeleteIfExists;
    }

    public void setShouldDeleteIfEmpty(boolean shouldDeleteIfEmpty) {
        this.shouldDeleteIfEmpty = shouldDeleteIfEmpty;
    }

    public void setSaveState(boolean saveState) {
        this.saveState = saveState;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public void setName(String name) {
        this.ecSupport.setName(name);
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public void setHeaderCallback(FlatFileHeaderCallback headerCallback) {
        this.headerCallback = headerCallback;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Stream {
        private FileOutputStream outputStream;
        private FileChannel fileChannel;
        private Writer writer;
        private BeanWriter beanWriter;
        private boolean restarted = false;
        private long lastMarkedByteOffsetPosition = 0L;
        private long itemsWritten = 0L;

        private Stream() {
        }

        public void open(ExecutionContext executionContext) throws ItemStreamException {
            File file;
            Assert.notNull((Object)BeanIOFlatFileItemWriter.this.resource, (String)"The resource must be set");
            try {
                file = BeanIOFlatFileItemWriter.this.resource.getFile();
            }
            catch (IOException e) {
                throw new ItemStreamException("Could not convert resource to file: '" + BeanIOFlatFileItemWriter.this.resource + "'", (Throwable)e);
            }
            if (executionContext.containsKey(BeanIOFlatFileItemWriter.this.ecSupport.getKey(BeanIOFlatFileItemWriter.RESTART_KEY))) {
                this.lastMarkedByteOffsetPosition = executionContext.getLong(BeanIOFlatFileItemWriter.this.ecSupport.getKey(BeanIOFlatFileItemWriter.RESTART_KEY));
                this.restarted = true;
            } else {
                try {
                    if (!BeanIOFlatFileItemWriter.this.append) {
                        if (file.exists()) {
                            if (!BeanIOFlatFileItemWriter.this.shouldDeleteIfExists) {
                                throw new ItemStreamException("File already exists: " + file.getAbsolutePath());
                            }
                            if (!file.delete()) {
                                throw new IOException("Could not delete file: " + file.getAbsolutePath());
                            }
                        }
                        if (file.getParent() != null) {
                            new File(file.getParent()).mkdirs();
                        }
                        if (!this.createNewFile(file)) {
                            throw new ItemStreamException("Output file was not created: " + file.getAbsolutePath());
                        }
                    } else if (!file.exists() && !this.createNewFile(file)) {
                        throw new ItemStreamException("Output file was not created: " + file.getAbsolutePath());
                    }
                }
                catch (IOException ioe) {
                    throw new ItemStreamException("Unable to create file: " + file.getAbsolutePath(), (Throwable)ioe);
                }
            }
            if (!file.canWrite()) {
                throw new ItemStreamException("File is not writable: " + file.getAbsolutePath());
            }
            boolean appending = false;
            try {
                this.outputStream = new FileOutputStream(file.getAbsolutePath(), true);
                this.fileChannel = this.outputStream.getChannel();
                this.writer = this.createBufferedWriter(this.fileChannel, BeanIOFlatFileItemWriter.this.encoding);
                this.writer.flush();
                long fileSize = this.fileChannel.size();
                if (BeanIOFlatFileItemWriter.this.append && fileSize > 0L) {
                    appending = true;
                }
                if (this.restarted) {
                    if (fileSize < this.lastMarkedByteOffsetPosition) {
                        throw new ItemStreamException("Current file size is smaller than size at last commit");
                    }
                    this.fileChannel.truncate(this.lastMarkedByteOffsetPosition);
                    this.fileChannel.position(this.lastMarkedByteOffsetPosition);
                }
                this.beanWriter = BeanIOFlatFileItemWriter.this.streamFactory.createWriter(BeanIOFlatFileItemWriter.this.streamName, ((BeanIOFlatFileItemWriter)BeanIOFlatFileItemWriter.this).stream.writer);
                if (this.restarted && this.beanWriter instanceof StatefulWriter) {
                    String namespace = BeanIOFlatFileItemWriter.this.ecSupport.getKey(BeanIOFlatFileItemWriter.WRITER_STATE_NAMESPACE);
                    HashMap<String, Object> writerState = new HashMap<String, Object>();
                    for (Map.Entry entry : executionContext.entrySet()) {
                        if (!((String)entry.getKey()).startsWith(namespace)) continue;
                        writerState.put((String)entry.getKey(), entry.getValue());
                    }
                    ((StatefulWriter)((Object)this.beanWriter)).restoreState(namespace, writerState);
                }
                this.itemsWritten = 0L;
            }
            catch (IOException ioe) {
                throw new ItemStreamException("Failed to initialize writer", (Throwable)ioe);
            }
            if (this.lastMarkedByteOffsetPosition == 0L && !appending && BeanIOFlatFileItemWriter.this.headerCallback != null) {
                try {
                    BeanIOFlatFileItemWriter.this.headerCallback.writeHeader(this.writer);
                    this.writer.write(BeanIOFlatFileItemWriter.this.lineSeparator);
                }
                catch (IOException e) {
                    throw new ItemStreamException("Could not write headers.  The file may be corrupt.", (Throwable)e);
                }
            }
        }

        public void update(ExecutionContext executionContext) throws ItemStreamException {
            Assert.notNull((Object)executionContext, (String)"ExecutionContext must not be null");
            try {
                long pos = 0L;
                if (this.fileChannel != null) {
                    this.beanWriter.flush();
                    pos = this.fileChannel.position();
                    if (BeanIOFlatFileItemWriter.this.transactional) {
                        pos += ((TransactionAwareBufferedWriter)this.writer).getBufferSize();
                    }
                }
                executionContext.putLong(BeanIOFlatFileItemWriter.this.ecSupport.getKey(BeanIOFlatFileItemWriter.RESTART_KEY), pos);
                if (this.beanWriter instanceof StatefulWriter) {
                    String namespace = BeanIOFlatFileItemWriter.this.ecSupport.getKey(BeanIOFlatFileItemWriter.WRITER_STATE_NAMESPACE);
                    HashMap<String, Object> writerState = new HashMap<String, Object>();
                    ((StatefulWriter)((Object)this.beanWriter)).updateState(namespace, writerState);
                    for (Map.Entry entry : writerState.entrySet()) {
                        executionContext.put((String)entry.getKey(), entry.getValue());
                    }
                }
            }
            catch (IOException e) {
                throw new ItemStreamException("ItemStream does not return current position properly", (Throwable)e);
            }
        }

        public void write(List<? extends T> items) throws Exception {
            for (Object item : items) {
                try {
                    this.beanWriter.write(item);
                    ++this.itemsWritten;
                }
                catch (BeanWriterException ex) {
                    throw new WriteFailedException("Writer failed: " + ex.toString(), (Throwable)ex);
                }
            }
            this.beanWriter.flush();
        }

        public void close() throws ItemStreamException {
            try {
                this.beanWriter.close();
            }
            catch (BeanWriterIOException ex) {
                throw new ItemStreamException("Unable to close the ItemWriter", (Throwable)ex);
            }
            finally {
                if (!BeanIOFlatFileItemWriter.this.transactional) {
                    this.destroy();
                }
            }
        }

        private void destroy() {
            block8: {
                try {
                    try {
                        if (this.outputStream != null) {
                            this.outputStream.close();
                        }
                    }
                    catch (IOException ioe) {
                        throw new ItemStreamException("Unable to close the the ItemWriter", (Throwable)ioe);
                    }
                    if (this.restarted || this.itemsWritten != 0L || !BeanIOFlatFileItemWriter.this.shouldDeleteIfEmpty) break block8;
                    try {
                        BeanIOFlatFileItemWriter.this.resource.getFile().delete();
                    }
                    catch (IOException ex) {
                        throw new ItemStreamException("Failed to delete empty file on close", (Throwable)ex);
                    }
                }
                finally {
                    this.beanWriter = null;
                    this.writer = null;
                    this.fileChannel = null;
                    this.outputStream = null;
                }
            }
        }

        private boolean createNewFile(File file) throws IOException {
            try {
                return file.createNewFile() && file.exists();
            }
            catch (IOException e) {
                if (file.exists()) {
                    return true;
                }
                throw e;
            }
        }

        private Writer createBufferedWriter(FileChannel fileChannel, String encoding) {
            try {
                Writer writer = Channels.newWriter((WritableByteChannel)fileChannel, encoding);
                writer = BeanIOFlatFileItemWriter.this.transactional ? new TransactionAwareBufferedWriter(writer, new Runnable(){

                    public void run() {
                        Stream.this.destroy();
                    }
                }) : new BufferedWriter(writer);
                return writer;
            }
            catch (UnsupportedCharsetException ex) {
                throw new ItemStreamException("Bad encoding configuration for output file " + fileChannel, (Throwable)ex);
            }
        }
    }
}

