/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.stream.fixedlength;

import java.io.IOException;
import java.io.Reader;
import org.beanio.stream.RecordIOException;
import org.beanio.stream.RecordReader;
import org.beanio.stream.fixedlength.FixedLengthParserConfiguration;
import org.beanio.stream.util.CommentReader;

public class FixedLengthReader
implements RecordReader {
    private char lineContinuationChar = (char)92;
    private boolean multilineEnabled = false;
    private char recordTerminator = '\u0000';
    private CommentReader commentReader = null;
    private transient Reader in;
    private transient String recordText;
    private transient int recordLineNumber;
    private transient int lineNumber = 0;
    private transient boolean skipLF = false;
    private transient boolean eof = false;

    public FixedLengthReader(Reader in) {
        this(in, null);
    }

    public FixedLengthReader(Reader in, FixedLengthParserConfiguration config) throws IllegalArgumentException {
        String s;
        if (config == null) {
            config = new FixedLengthParserConfiguration();
        }
        this.in = in;
        if (config.getRecordTerminator() != null && !"\r\n".equals(s = config.getRecordTerminator())) {
            if (s.length() == 1) {
                this.recordTerminator = s.charAt(0);
            } else if (s.length() > 1) {
                throw new IllegalArgumentException("Record terminator must be a single character");
            }
        }
        if (config.getLineContinuationCharacter() == null) {
            this.multilineEnabled = false;
        } else {
            this.multilineEnabled = true;
            this.lineContinuationChar = config.getLineContinuationCharacter().charValue();
            if (this.recordTerminator != '\u0000' && this.lineContinuationChar == this.recordTerminator) {
                throw new IllegalArgumentException("The line continuation character and record terminator cannot match.");
            }
        }
        if (config.isCommentEnabled()) {
            this.commentReader = new CommentReader(in, config.getComments(), Character.valueOf(this.recordTerminator));
        }
    }

    public int getRecordLineNumber() {
        if (this.recordLineNumber < 0) {
            return this.recordLineNumber;
        }
        return this.recordTerminator == '\u0000' ? this.recordLineNumber : 0;
    }

    public String getRecordText() {
        return this.recordText;
    }

    public String read() throws IOException, RecordIOException {
        int n;
        int lines;
        if (this.eof) {
            this.recordText = null;
            this.recordLineNumber = -1;
            return null;
        }
        ++this.lineNumber;
        if (this.commentReader != null && (lines = this.commentReader.skipComments(this.skipLF)) > 0) {
            if (this.commentReader.isEOF()) {
                this.eof = true;
                this.recordText = null;
                this.recordLineNumber = -1;
                return null;
            }
            this.lineNumber += lines;
            this.skipLF = this.commentReader.isSkipLF();
        }
        int lineOffset = 0;
        boolean continued = false;
        boolean eol = false;
        StringBuilder text = new StringBuilder();
        StringBuilder record = new StringBuilder();
        while (!eol && (n = this.in.read()) != -1) {
            char c = (char)n;
            if (this.skipLF) {
                this.skipLF = false;
                if (c == '\n') continue;
            }
            if (continued) {
                continued = false;
                text.append(c);
                if (this.endOfRecord(c)) {
                    ++this.lineNumber;
                    ++lineOffset;
                    continue;
                }
                record.append(this.lineContinuationChar);
            }
            if (this.multilineEnabled && c == this.lineContinuationChar) {
                continued = true;
                continue;
            }
            if (this.endOfRecord(c)) {
                eol = true;
                continue;
            }
            text.append(c);
            record.append(c);
        }
        this.recordLineNumber = this.lineNumber - lineOffset;
        this.recordText = text.toString();
        if (eol) {
            return record.toString();
        }
        this.eof = true;
        if (continued) {
            this.recordText = null;
            this.recordLineNumber = -1;
            throw new RecordIOException("Unexpected end of stream after line continuation at line " + this.lineNumber);
        }
        if (this.recordText.length() == 0) {
            this.recordText = null;
            this.recordLineNumber = -1;
            return null;
        }
        return record.toString();
    }

    private boolean endOfRecord(char c) {
        if (this.recordTerminator == '\u0000') {
            if (c == '\r') {
                this.skipLF = true;
                return true;
            }
            return c == '\n';
        }
        return c == this.recordTerminator;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

