/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.stream.xml;

import java.io.IOException;
import java.io.Reader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.beanio.internal.util.DomUtil;
import org.beanio.stream.RecordIOException;
import org.beanio.stream.RecordReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlReader
implements RecordReader {
    public static final String GROUP_COUNT = "count";
    public static final String IS_NAMESPACE_IGNORED = "namespaceIgnored";
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    private XMLStreamReader in;
    private Document document;
    private Node parentNode;
    private Node recordNode;
    private boolean readFully = false;
    private transient int recordLineNumber = -1;
    private transient boolean eof = false;

    public XmlReader(Reader reader) {
        this(reader, null);
    }

    public XmlReader(Reader reader, Document base) {
        if (reader == null) {
            throw new IllegalArgumentException("reader is null");
        }
        try {
            this.in = xmlInputFactory.createXMLStreamReader(reader);
        }
        catch (XMLStreamException ex) {
            throw new IllegalArgumentException("Failed to create XMLStreamReader: " + ex.getMessage(), ex);
        }
        if (base == null) {
            base = DomUtil.newDocument();
        }
        this.document = base;
        if (base.getDocumentElement() == null) {
            this.readFully = true;
            this.parentNode = base;
        } else {
            this.readFully = false;
            this.parentNode = null;
        }
    }

    public Document read() throws IOException, RecordIOException {
        if (this.eof) {
            return null;
        }
        try {
            if (this.parentNode != null) {
                if (this.recordNode != null) {
                    this.parentNode.removeChild(this.recordNode);
                }
                this.recordNode = null;
            }
            return this.readRecord() ? this.document : null;
        }
        catch (XMLStreamException ex) {
            throw new RecordIOException(ex.getMessage(), ex);
        }
    }

    private boolean readRecord() throws XMLStreamException {
        int recordPosition = this.readFully ? 0 : -1;
        Node node = this.parentNode;
        while (this.in.hasNext()) {
            int event = this.in.next();
            switch (event) {
                case 1: {
                    if (recordPosition < 0) {
                        if (node == null) {
                            node = this.document.getDocumentElement();
                            if (this.isNode(node, this.in.getNamespaceURI(), this.in.getLocalName())) {
                                node.setUserData(GROUP_COUNT, 1, null);
                                break;
                            }
                        } else {
                            Element baseElement = this.findChild((Element)node, this.in.getNamespaceURI(), this.in.getLocalName());
                            if (baseElement != null) {
                                Integer count = (Integer)baseElement.getUserData(GROUP_COUNT);
                                baseElement.setUserData(GROUP_COUNT, count == null ? 1 : 1 + count, null);
                                node = baseElement;
                                break;
                            }
                        }
                        this.recordLineNumber = this.in.getLocation().getLineNumber();
                        this.parentNode = node;
                    }
                    Element e = this.document.createElementNS(this.in.getNamespaceURI(), this.in.getLocalName());
                    int j = this.in.getAttributeCount();
                    for (int i = 0; i < j; ++i) {
                        e.setAttributeNS(this.in.getAttributeNamespace(i), this.in.getAttributeLocalName(i), this.in.getAttributeValue(i));
                    }
                    node.appendChild(e);
                    node = e;
                    if (this.recordNode == null) {
                        this.recordNode = node;
                    }
                    ++recordPosition;
                    break;
                }
                case 4: {
                    if (recordPosition < 0) break;
                    node.appendChild(this.document.createTextNode(this.in.getText()));
                    break;
                }
                case 2: {
                    Node parent = node.getParentNode();
                    node = parent.getNodeType() == 1 ? (Element)parent : null;
                    if (recordPosition < 0 || recordPosition-- != 0) break;
                    return true;
                }
            }
        }
        this.eof = true;
        return this.readFully;
    }

    private Element findChild(Element parent, String namespace, String name) {
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element;
            if (node.getNodeType() != 1 || !this.isNode(element = (Element)node, namespace, name)) continue;
            return element;
        }
        return null;
    }

    private boolean isNode(Node node, String namespace, String name) {
        if (node.getLocalName().equals(name)) {
            if (Boolean.TRUE.equals(node.getUserData(IS_NAMESPACE_IGNORED))) {
                return true;
            }
            String uri = node.getNamespaceURI();
            if (namespace == null && uri == null) {
                return true;
            }
            return uri != null && uri.equals(namespace);
        }
        return false;
    }

    public void close() throws IOException {
        try {
            this.in.close();
        }
        catch (XMLStreamException e) {
            IOException ex = new IOException("XMLStreamException caught closing input stream");
            ex.initCause(e);
            throw ex;
        }
    }

    public int getRecordLineNumber() {
        return this.recordLineNumber;
    }

    public String getRecordText() {
        return null;
    }

    static {
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
    }
}

