/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.types;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import org.beanio.types.ConfigurableTypeHandler;
import org.beanio.types.LocaleSupport;
import org.beanio.types.TypeConversionException;

public abstract class DateTypeHandlerSupport
extends LocaleSupport
implements ConfigurableTypeHandler,
Cloneable {
    protected String pattern = null;
    protected boolean lenient = false;
    protected TimeZone timeZone = null;
    private transient DateFormat format;

    public DateTypeHandlerSupport() {
    }

    public DateTypeHandlerSupport(String pattern) {
        this.pattern = pattern;
    }

    protected Date parseDate(String text) throws TypeConversionException {
        if ("".equals(text)) {
            return null;
        }
        ParsePosition pp = new ParsePosition(0);
        Date date = this.getFormat().parse(text, pp);
        if (pp.getErrorIndex() >= 0 || pp.getIndex() != text.length()) {
            throw new TypeConversionException("Invalid date");
        }
        return date;
    }

    protected String formatDate(Date date) {
        return date == null ? null : this.getFormat().format(date);
    }

    private DateFormat getFormat() {
        return this.format != null ? this.format : this.createDateFormat();
    }

    protected DateFormat createDateFormat() {
        if (this.pattern == null) {
            return this.createDefaultDateFormat();
        }
        SimpleDateFormat df = new SimpleDateFormat(this.pattern, this.locale);
        df.setLenient(this.lenient);
        if (this.timeZone != null) {
            df.setTimeZone(this.timeZone);
        }
        return df;
    }

    protected DateFormat createDefaultDateFormat() {
        return DateFormat.getDateTimeInstance(2, 2, this.locale);
    }

    public DateTypeHandlerSupport newInstance(Properties properties) throws IllegalArgumentException {
        String pattern = properties.getProperty("format");
        if (pattern == null || "".equals(pattern)) {
            return this;
        }
        if (pattern.equals(this.getPattern())) {
            return this;
        }
        try {
            DateTypeHandlerSupport handler = (DateTypeHandlerSupport)this.clone();
            handler.setPattern(pattern);
            handler.lenient = this.lenient;
            handler.timeZone = this.timeZone;
            handler.format = handler.createDateFormat();
            return handler;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) throws IllegalArgumentException {
        try {
            if (pattern != null) {
                new SimpleDateFormat(pattern);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Invalid date format pattern '" + pattern + "': " + ex.getMessage());
        }
        this.pattern = pattern;
    }

    public void setTimeZoneId(String name) {
        this.timeZone = name == null || "".equals(name) ? null : TimeZone.getTimeZone(name);
    }

    public String getTimeZoneId() {
        return this.timeZone == null ? null : this.timeZone.getID();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }
}

