/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.io.IOContext;
import de.undercouch.bson4jackson.BsonGenerator;
import de.undercouch.bson4jackson.BsonParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

public class BsonFactory
extends JsonFactory {
    private static final long serialVersionUID = 1991836957699496674L;
    private static final int DEFAULT_BSON_GENERATOR_FEATURE_FLAGS = 0;
    private static final int DEFAULT_BSON_PARSER_FEATURE_FLAGS = 0;
    protected int _bsonGeneratorFeatures = 0;
    protected int _bsonParserFeatures = 0;

    public BsonFactory() {
        this(null);
    }

    public BsonFactory(ObjectCodec oc) {
        super(oc);
    }

    public final BsonFactory configure(BsonGenerator.Feature f, boolean state) {
        if (state) {
            return this.enable(f);
        }
        return this.disable(f);
    }

    public BsonFactory enable(BsonGenerator.Feature f) {
        this._bsonGeneratorFeatures |= f.getMask();
        return this;
    }

    public BsonFactory disable(BsonGenerator.Feature f) {
        this._bsonGeneratorFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(BsonGenerator.Feature f) {
        return (this._bsonGeneratorFeatures & f.getMask()) != 0;
    }

    public final BsonFactory configure(BsonParser.Feature f, boolean state) {
        if (state) {
            return this.enable(f);
        }
        return this.disable(f);
    }

    public BsonFactory enable(BsonParser.Feature f) {
        this._bsonParserFeatures |= f.getMask();
        return this;
    }

    public BsonFactory disable(BsonParser.Feature f) {
        this._bsonParserFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(BsonParser.Feature f) {
        return (this._bsonParserFeatures & f.getMask()) != 0;
    }

    protected BsonGenerator _createGenerator(Writer out, IOContext ctxt) {
        throw new UnsupportedOperationException("Can not create writer for non-byte-based target");
    }

    @Deprecated
    protected BsonGenerator _createJsonGenerator(Writer out, IOContext ctxt) {
        return this._createGenerator(out, ctxt);
    }

    @Deprecated
    protected BsonParser _createJsonParser(byte[] data, int offset, int len, IOContext ctxt) {
        return this._createParser(data, offset, len, ctxt);
    }

    @Deprecated
    protected BsonParser _createJsonParser(InputStream in, IOContext ctxt) {
        return this._createParser(in, ctxt);
    }

    @Deprecated
    protected BsonParser _createJsonParser(Reader r, IOContext ctxt) {
        return this._createParser(r, ctxt);
    }

    protected BsonParser _createParser(byte[] data, int offset, int len, IOContext ctxt) {
        return this._createParser(new ByteArrayInputStream(data, offset, len), ctxt);
    }

    protected BsonParser _createParser(InputStream in, IOContext ctxt) {
        BsonParser p = new BsonParser(ctxt, this._parserFeatures, this._bsonParserFeatures, in);
        ObjectCodec codec = this.getCodec();
        if (codec != null) {
            p.setCodec(codec);
        }
        return p;
    }

    protected BsonParser _createParser(Reader r, IOContext ctxt) {
        throw new UnsupportedOperationException("Can not create reader for non-byte-based source");
    }

    protected BsonGenerator _createUTF8Generator(OutputStream out, IOContext ctxt) throws IOException {
        return this.createGenerator(out);
    }

    @Deprecated
    protected BsonGenerator _createUTF8JsonGenerator(OutputStream out, IOContext ctxt) throws IOException {
        return this._createUTF8Generator(out, ctxt);
    }

    protected Writer _createWriter(OutputStream out, JsonEncoding enc, IOContext ctxt) throws IOException {
        throw new UnsupportedOperationException("Can not create generator for non-byte-based target");
    }

    public BsonGenerator createGenerator(File f, JsonEncoding enc) throws IOException {
        OutputStream out = new FileOutputStream(f);
        IOContext ctxt = this._createContext(out, true);
        ctxt.setEncoding(enc);
        if (enc == JsonEncoding.UTF8 && this._outputDecorator != null) {
            out = this._outputDecorator.decorate(ctxt, out);
        }
        return this.createGenerator(out, enc);
    }

    public BsonGenerator createGenerator(OutputStream out) throws IOException {
        return this.createGenerator(out, JsonEncoding.UTF8);
    }

    public BsonGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        IOContext ctxt = this._createContext(out, true);
        ctxt.setEncoding(enc);
        if (enc == JsonEncoding.UTF8 && this._outputDecorator != null) {
            out = this._outputDecorator.decorate(ctxt, out);
        }
        BsonGenerator g = new BsonGenerator(this._generatorFeatures, this._bsonGeneratorFeatures, out);
        ObjectCodec codec = this.getCodec();
        if (codec != null) {
            g.setCodec(codec);
        }
        return g;
    }

    public BsonGenerator createGenerator(Writer writer) {
        throw new UnsupportedOperationException("Can not create generator for non-byte-based target");
    }

    public BsonGenerator createJsonGenerator(File f, JsonEncoding enc) throws IOException {
        return this.createGenerator(f, enc);
    }

    public BsonGenerator createJsonGenerator(OutputStream out) throws IOException {
        return this.createGenerator(out);
    }

    public BsonGenerator createJsonGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        return this.createGenerator(out, enc);
    }

    public BsonGenerator createJsonGenerator(Writer out) {
        return this.createGenerator(out);
    }

    public BsonParser createJsonParser(byte[] data) throws IOException {
        return this.createParser(data);
    }

    public BsonParser createJsonParser(byte[] data, int offset, int len) throws IOException {
        return this.createParser(data, offset, len);
    }

    public BsonParser createJsonParser(File f) throws IOException {
        return this.createParser(f);
    }

    public BsonParser createJsonParser(InputStream in) throws IOException {
        return this.createParser(in);
    }

    public BsonParser createJsonParser(Reader r) {
        return this.createParser(r);
    }

    public BsonParser createJsonParser(String content) {
        return this.createParser(content);
    }

    public BsonParser createJsonParser(URL url) throws IOException {
        return this.createParser(url);
    }

    public BsonParser createParser(byte[] data) throws IOException {
        InputStream in;
        IOContext ctxt = this._createContext(data, true);
        if (this._inputDecorator != null && (in = this._inputDecorator.decorate(ctxt, data, 0, data.length)) != null) {
            return this._createParser(in, ctxt);
        }
        return this._createParser(data, 0, data.length, ctxt);
    }

    public BsonParser createParser(byte[] data, int offset, int len) throws IOException {
        InputStream in;
        IOContext ctxt = this._createContext(data, true);
        if (this._inputDecorator != null && (in = this._inputDecorator.decorate(ctxt, data, offset, len)) != null) {
            return this._createParser(in, ctxt);
        }
        return this._createParser(data, offset, len, ctxt);
    }

    public BsonParser createParser(File f) throws IOException {
        IOContext ctxt = this._createContext(f, true);
        InputStream in = new FileInputStream(f);
        if (this._inputDecorator != null) {
            in = this._inputDecorator.decorate(ctxt, in);
        }
        return this._createParser(in, ctxt);
    }

    public BsonParser createParser(InputStream in) throws IOException {
        IOContext ctxt = this._createContext(in, false);
        if (this._inputDecorator != null) {
            in = this._inputDecorator.decorate(ctxt, in);
        }
        return this._createParser(in, ctxt);
    }

    public BsonParser createParser(Reader r) {
        throw new UnsupportedOperationException("Can not create reader for non-byte-based source");
    }

    public BsonParser createParser(String content) {
        throw new UnsupportedOperationException("Can not create reader for non-byte-based source");
    }

    public BsonParser createParser(URL url) throws IOException {
        IOContext ctxt = this._createContext(url, true);
        InputStream in = this._optimizedStreamFromURL(url);
        if (this._inputDecorator != null) {
            in = this._inputDecorator.decorate(ctxt, in);
        }
        return this._createParser(in, ctxt);
    }
}

