/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.runner;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.batch.api.listener.StepListener;
import javax.batch.api.partition.PartitionAnalyzer;
import javax.batch.api.partition.PartitionMapper;
import javax.batch.api.partition.PartitionReducer;
import javax.batch.operations.BatchRuntimeException;
import javax.batch.runtime.BatchStatus;
import javax.transaction.TransactionManager;
import org.jberet._private.BatchLogger;
import org.jberet._private.BatchMessages;
import org.jberet.creation.JobScopedContextImpl;
import org.jberet.job.model.Chunk;
import org.jberet.job.model.Listeners;
import org.jberet.job.model.Partition;
import org.jberet.job.model.PartitionPlan;
import org.jberet.job.model.PropertyResolver;
import org.jberet.job.model.RefArtifact;
import org.jberet.job.model.Step;
import org.jberet.runtime.JobStopNotificationListener;
import org.jberet.runtime.PartitionExecutionImpl;
import org.jberet.runtime.StepExecutionImpl;
import org.jberet.runtime.context.AbstractContext;
import org.jberet.runtime.context.JobContextImpl;
import org.jberet.runtime.context.StepContextImpl;
import org.jberet.runtime.runner.AbstractRunner;
import org.jberet.runtime.runner.BatchletRunner;
import org.jberet.runtime.runner.ChunkRunner;
import org.jberet.runtime.runner.CompositeExecutionRunner;
import org.jberet.runtime.runner.ThreadPartitionHandlerFactory;
import org.jberet.spi.JobTask;
import org.jberet.spi.PartitionHandler;
import org.jberet.spi.PartitionHandlerFactory;
import org.jberet.tx.LocalTransactionManager;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class StepExecutionRunner
extends AbstractRunner<StepContextImpl>
implements JobTask {
    Step step;
    private final List<StepListener> stepListeners = new ArrayList<StepListener>();
    PartitionMapper mapper;
    PartitionPlan plan;
    PartitionReducer reducer;
    PartitionAnalyzer analyzer;
    int numOfPartitions;
    int numOfThreads;
    Properties[] partitionProperties;
    boolean isPartitioned;
    final TransactionManager tm;
    final StepExecutionImpl stepExecution;
    private boolean analyzerTxEnabled = true;
    private static PrivilegedAction<PartitionHandlerFactory> loaderAction = () -> {
        ServiceLoader<PartitionHandlerFactory> serviceLoader = ServiceLoader.load(PartitionHandlerFactory.class);
        if (serviceLoader.iterator().hasNext()) {
            return serviceLoader.iterator().next();
        }
        return null;
    };

    public StepExecutionRunner(StepContextImpl stepContext, CompositeExecutionRunner enclosingRunner) {
        super(stepContext, enclosingRunner);
        this.step = stepContext.getStep();
        this.stepExecution = (StepExecutionImpl)stepContext.getStepExecution();
        this.tm = StepExecutionRunner.getTransactionManager(this.jobContext, this.step);
        if (this.step.getProperties() != null) {
            this.analyzerTxEnabled = !Boolean.parseBoolean(this.step.getProperties().get("jberet.analyzer.txDisabled"));
        }
        this.createStepListeners();
        this.initPartitionConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block45: {
            block44: {
                RefArtifact batchlet;
                Chunk chunk;
                boolean loopAllowed;
                List<String> executedStepIds;
                boolean enterBeforeStep;
                block42: {
                    block43: {
                        block40: {
                            block41: {
                                int startCount;
                                Boolean allowStartIfComplete = ((StepContextImpl)this.batchContext).getAllowStartIfComplete();
                                if (allowStartIfComplete == Boolean.FALSE) break block45;
                                enterBeforeStep = false;
                                executedStepIds = this.jobContext.getExecutedStepIds();
                                loopAllowed = this.loopAllowed();
                                if (!loopAllowed && executedStepIds.contains(this.step.getId())) {
                                    throw BatchMessages.MESSAGES.loopbackStep(this.step.getId(), executedStepIds.toString());
                                }
                                int startLimit = this.step.getStartLimitInt();
                                if (startLimit > 0 && (startCount = this.jobContext.getJobRepository().countStepStartTimes(this.stepExecution.getStepName(), this.jobContext.getInstanceId())) >= startLimit) {
                                    throw BatchMessages.MESSAGES.stepReachedStartLimit(this.step.getId(), startLimit, startCount);
                                }
                                ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.STARTED);
                                this.jobContext.getJobRepository().addStepExecution(this.jobContext.getJobExecution(), this.stepExecution);
                                chunk = this.step.getChunk();
                                batchlet = this.step.getBatchlet();
                                if (chunk != null || batchlet != null) break block40;
                                ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.ABANDONED);
                                BatchLogger.LOGGER.stepContainsNoChunkOrBatchlet(this.id);
                                if (!enterBeforeStep) break block41;
                                for (StepListener l : this.stepListeners) {
                                    try {
                                        l.afterStep();
                                    }
                                    catch (Throwable e) {
                                        BatchLogger.LOGGER.failToRunJob(e, this.jobContext.getJobName(), this.step.getId(), l);
                                        ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.FAILED);
                                        if (((StepContextImpl)this.batchContext).getException() == null) continue;
                                        ((StepContextImpl)this.batchContext).setException((Exception)((Object)new BatchRuntimeException(e)));
                                    }
                                }
                                ((StepContextImpl)this.batchContext).savePersistentData(true);
                            }
                            return;
                        }
                        if (chunk == null || batchlet == null) break block42;
                        ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.ABANDONED);
                        BatchLogger.LOGGER.cannotContainBothChunkAndBatchlet(this.id);
                        if (!enterBeforeStep) break block43;
                        for (StepListener l : this.stepListeners) {
                            try {
                                l.afterStep();
                            }
                            catch (Throwable e) {
                                BatchLogger.LOGGER.failToRunJob(e, this.jobContext.getJobName(), this.step.getId(), l);
                                ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.FAILED);
                                if (((StepContextImpl)this.batchContext).getException() == null) continue;
                                ((StepContextImpl)this.batchContext).setException((Exception)((Object)new BatchRuntimeException(e)));
                            }
                        }
                        ((StepContextImpl)this.batchContext).savePersistentData(true);
                    }
                    return;
                }
                try {
                    enterBeforeStep = true;
                    for (StepListener l : this.stepListeners) {
                        l.beforeStep();
                    }
                    this.runBatchletOrChunk(batchlet, chunk);
                    if (!loopAllowed) {
                        executedStepIds.add(this.step.getId());
                    }
                    if (!enterBeforeStep) break block44;
                }
                catch (Throwable e) {
                    try {
                        BatchLogger.LOGGER.failToRunJob(e, this.jobContext.getJobName(), this.step.getId(), this.step);
                        if (e instanceof Exception) {
                            ((StepContextImpl)this.batchContext).setException((Exception)e);
                        } else {
                            ((StepContextImpl)this.batchContext).setException((Exception)((Object)new BatchRuntimeException(e)));
                        }
                        ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.FAILED);
                        break block44;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (enterBeforeStep) {
                            for (StepListener l : this.stepListeners) {
                                try {
                                    l.afterStep();
                                }
                                catch (Throwable e2) {
                                    BatchLogger.LOGGER.failToRunJob(e2, this.jobContext.getJobName(), this.step.getId(), l);
                                    ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.FAILED);
                                    if (((StepContextImpl)this.batchContext).getException() == null) continue;
                                    ((StepContextImpl)this.batchContext).setException((Exception)((Object)new BatchRuntimeException(e2)));
                                }
                            }
                            ((StepContextImpl)this.batchContext).savePersistentData(true);
                        }
                    }
                }
                for (StepListener l : this.stepListeners) {
                    try {
                        l.afterStep();
                    }
                    catch (Throwable e) {
                        BatchLogger.LOGGER.failToRunJob(e, this.jobContext.getJobName(), this.step.getId(), l);
                        ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.FAILED);
                        if (((StepContextImpl)this.batchContext).getException() == null) continue;
                        ((StepContextImpl)this.batchContext).setException((Exception)((Object)new BatchRuntimeException(e)));
                    }
                }
                ((StepContextImpl)this.batchContext).savePersistentData(true);
            }
            this.jobContext.destroyArtifact(this.mapper, this.reducer, this.analyzer);
            this.jobContext.destroyArtifact(this.stepListeners);
            JobScopedContextImpl.ScopedInstance.destroy(((StepContextImpl)this.batchContext).getScopedBeans());
            switch (((StepContextImpl)this.batchContext).getBatchStatus()) {
                case COMPLETED: {
                    break;
                }
                case STARTED: {
                    ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.COMPLETED);
                    break;
                }
                case FAILED: {
                    for (AbstractContext e : ((StepContextImpl)this.batchContext).getOuterContexts()) {
                        e.setBatchStatus(BatchStatus.FAILED);
                    }
                    break;
                }
                case STOPPING: {
                    ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.STOPPED);
                }
            }
        }
        ((StepContextImpl)this.batchContext).getJobContext().getJobRepository().updateStepExecution(this.stepExecution);
        ((StepContextImpl)this.batchContext).setTransientUserData(null);
        switch (((StepContextImpl)this.batchContext).getBatchStatus()) {
            case COMPLETED: {
                String next1 = this.resolveTransitionElements(this.step.getTransitionElements(), this.step.getAttributeNext(), false);
                this.enclosingRunner.runJobElement(next1, this.stepExecution);
                break;
            }
            case FAILED: {
                String next2 = this.resolveTransitionElements(this.step.getTransitionElements(), null, false);
                if (next2 == null || this.jobContext.getExecutedStepIds().contains(next2)) break;
                for (AbstractContext e : ((StepContextImpl)this.batchContext).getOuterContexts()) {
                    e.setBatchStatus(BatchStatus.STARTED);
                }
                this.enclosingRunner.runJobElement(next2, this.stepExecution);
            }
        }
    }

    private void runBatchletOrChunk(RefArtifact batchlet, Chunk chunk) throws Exception {
        if (this.isPartitioned) {
            this.beginPartition();
        } else if (chunk != null) {
            ChunkRunner chunkRunner = new ChunkRunner((StepContextImpl)this.batchContext, this.enclosingRunner, chunk, this.tm, null);
            chunkRunner.run();
        } else {
            BatchletRunner batchletRunner = new BatchletRunner((StepContextImpl)this.batchContext, this.enclosingRunner, batchlet, null);
            batchletRunner.run();
        }
    }

    private void beginPartition() throws Exception {
        BatchStatus consolidatedBatchStatus;
        PartitionHandler partitionHandler;
        block40: {
            if (this.reducer != null) {
                this.reducer.beginPartitionedStep();
            }
            boolean isOverride = false;
            if (this.mapper != null) {
                javax.batch.api.partition.PartitionPlan partitionPlan = this.mapper.mapPartitions();
                isOverride = partitionPlan.getPartitionsOverride();
                this.numOfPartitions = partitionPlan.getPartitions();
                this.numOfThreads = partitionPlan.getThreads();
                this.numOfThreads = this.numOfThreads == 0 ? this.numOfPartitions : this.numOfThreads;
                this.partitionProperties = partitionPlan.getPartitionProperties();
            } else {
                this.numOfPartitions = this.plan.getPartitionsInt();
                this.numOfThreads = this.plan.getThreadsInt();
                List<org.jberet.job.model.Properties> propertiesList = this.plan.getPropertiesList();
                this.partitionProperties = new Properties[propertiesList.size()];
                for (org.jberet.job.model.Properties props : propertiesList) {
                    int idx = props.getPartition() == null ? 0 : Integer.parseInt(props.getPartition());
                    this.partitionProperties[idx] = org.jberet.job.model.Properties.toJavaUtilProperties(props);
                }
            }
            StepExecutionImpl originalStepExecution = ((StepContextImpl)this.batchContext).getOriginalStepExecution();
            boolean isStepRestart = originalStepExecution != null;
            boolean isRestartNotOverride = isStepRestart && !isOverride && ((StepContextImpl)this.batchContext).getAllowStartIfComplete() != Boolean.TRUE;
            List<PartitionExecutionImpl> abortedPartitionExecutionsFromPrevious = null;
            if (isRestartNotOverride) {
                BatchStatus oldStatus = originalStepExecution.getBatchStatus();
                long oldStepExecutionId = originalStepExecution.getStepExecutionId();
                if (oldStatus == BatchStatus.FAILED || oldStatus == BatchStatus.STOPPED || oldStatus == BatchStatus.COMPLETED) {
                    abortedPartitionExecutionsFromPrevious = this.jobContext.getJobRepository().getPartitionExecutions(oldStepExecutionId, originalStepExecution, true, this.jobContext.getClassLoader());
                } else {
                    List<PartitionExecutionImpl> partitionExecutionsFromPrevious = this.jobContext.getJobRepository().getPartitionExecutions(oldStepExecutionId, originalStepExecution, false, this.jobContext.getClassLoader());
                    abortedPartitionExecutionsFromPrevious = new ArrayList<PartitionExecutionImpl>();
                    if (this.numOfPartitions == partitionExecutionsFromPrevious.size()) {
                        for (PartitionExecutionImpl e : partitionExecutionsFromPrevious) {
                            if (e.getBatchStatus() == BatchStatus.COMPLETED) continue;
                            abortedPartitionExecutionsFromPrevious.add(e);
                        }
                    } else {
                        int[] coveredPartitions = new int[this.numOfPartitions];
                        Arrays.fill(coveredPartitions, 0);
                        for (PartitionExecutionImpl e : partitionExecutionsFromPrevious) {
                            coveredPartitions[e.getPartitionId()] = 1;
                            if (e.getBatchStatus() == BatchStatus.COMPLETED) continue;
                            abortedPartitionExecutionsFromPrevious.add(e);
                        }
                        for (int i = 0; i < coveredPartitions.length; ++i) {
                            if (coveredPartitions[i] != 0) continue;
                            abortedPartitionExecutionsFromPrevious.add(new PartitionExecutionImpl(i, oldStepExecutionId, originalStepExecution.getStepName(), BatchStatus.FAILED, BatchStatus.FAILED.name(), null, null, null));
                        }
                    }
                }
                this.numOfPartitions = abortedPartitionExecutionsFromPrevious.size();
            }
            ArrayBlockingQueue<Boolean> completedPartitionThreads = null;
            if (this.numOfPartitions > this.numOfThreads) {
                completedPartitionThreads = new ArrayBlockingQueue<Boolean>(this.numOfPartitions);
            }
            LinkedBlockingQueue<Serializable> collectorDataQueue = new LinkedBlockingQueue<Serializable>();
            PartitionHandlerFactory partitionHandlerFactory = StepExecutionRunner.getPartitionHandlerFactory();
            partitionHandler = partitionHandlerFactory.createPartitionHandler((StepContextImpl)this.batchContext, this);
            partitionHandler.setResourceTracker(completedPartitionThreads);
            partitionHandler.setCollectorDataQueue(collectorDataQueue);
            if (partitionHandler instanceof JobStopNotificationListener) {
                this.jobContext.getJobExecution().registerJobStopNotifier((JobStopNotificationListener)((Object)partitionHandler));
            }
            for (int i = 0; i < this.numOfPartitions; ++i) {
                PartitionExecutionImpl partitionExecution = isRestartNotOverride ? abortedPartitionExecutionsFromPrevious.get(i) : null;
                int partitionIndex = isRestartNotOverride ? partitionExecution.getPartitionId() : i;
                StepContextImpl stepContext1 = ((StepContextImpl)this.batchContext).clone();
                Step step1 = stepContext1.getStep();
                PartitionExecutionImpl partitionExecution1 = (PartitionExecutionImpl)stepContext1.getStepExecution();
                PropertyResolver resolver = new PropertyResolver();
                if (partitionIndex >= 0 && partitionIndex < this.partitionProperties.length) {
                    resolver.setPartitionPlanProperties(this.partitionProperties[partitionIndex]);
                    partitionExecution1.setPartitionId(partitionIndex);
                } else {
                    partitionExecution1.setPartitionId(i);
                }
                resolver.setResolvePartitionPlanProperties(true);
                resolver.resolve(step1);
                if (isRestartNotOverride) {
                    stepContext1.setPersistentUserData(partitionExecution.getPersistentUserData());
                    stepContext1.getStepExecution().setReaderCheckpointInfo(partitionExecution.getReaderCheckpointInfo());
                    stepContext1.getStepExecution().setWriterCheckpointInfo(partitionExecution.getWriterCheckpointInfo());
                }
                if (isStepRestart && isOverride && this.reducer != null) {
                    this.reducer.rollbackPartitionedStep();
                }
                if (i >= this.numOfThreads) {
                    completedPartitionThreads.take();
                }
                this.jobContext.getJobRepository().addPartitionExecution(this.stepExecution, partitionExecution1);
                partitionHandler.submitPartitionTask(stepContext1, i, this.numOfPartitions);
            }
            consolidatedBatchStatus = BatchStatus.STARTED;
            ArrayList<PartitionExecutionImpl> fromAllPartitions = new ArrayList<PartitionExecutionImpl>();
            if (this.analyzer != null && this.analyzerTxEnabled) {
                this.tm.begin();
            }
            try {
                while (fromAllPartitions.size() < this.numOfPartitions) {
                    Serializable data = (Serializable)collectorDataQueue.take();
                    if (data instanceof PartitionExecutionImpl) {
                        PartitionExecutionImpl s = (PartitionExecutionImpl)data;
                        if (this.step.getChunk() != null) {
                            this.stepExecution.getStepMetrics().addStepMetrics(s.getStepMetrics());
                        }
                        this.jobContext.getJobRepository().savePersistentData(this.jobContext.getJobExecution(), s);
                        fromAllPartitions.add(s);
                        BatchStatus bs = s.getBatchStatus();
                        if (bs == BatchStatus.FAILED || bs == BatchStatus.STOPPED) {
                            if (consolidatedBatchStatus != BatchStatus.FAILED) {
                                consolidatedBatchStatus = bs;
                            }
                            if (((StepContextImpl)this.batchContext).getException() == null && s.getException() != null) {
                                ((StepContextImpl)this.batchContext).setException(s.getException());
                            }
                        }
                        if (this.analyzer == null) continue;
                        this.analyzer.analyzeStatus(bs, s.getExitStatus());
                        continue;
                    }
                    if (this.analyzer == null) continue;
                    this.analyzer.analyzeCollectorData(data);
                }
                if (this.analyzer != null && this.analyzerTxEnabled && (consolidatedBatchStatus == BatchStatus.FAILED || consolidatedBatchStatus == BatchStatus.STOPPED)) {
                    this.tm.rollback();
                } else {
                    if (this.reducer != null) {
                        this.reducer.beforePartitionedStepCompletion();
                    }
                    if (this.analyzer != null && this.analyzerTxEnabled) {
                        this.tm.commit();
                    }
                }
                if (this.reducer != null) {
                    if (consolidatedBatchStatus == BatchStatus.FAILED || consolidatedBatchStatus == BatchStatus.STOPPED) {
                        this.reducer.rollbackPartitionedStep();
                        this.reducer.afterPartitionedStepCompletion(PartitionReducer.PartitionStatus.ROLLBACK);
                    } else {
                        this.reducer.afterPartitionedStepCompletion(PartitionReducer.PartitionStatus.COMMIT);
                    }
                }
            }
            catch (Exception e) {
                BatchLogger.LOGGER.failToRunJob(e, this.jobContext.getJobName(), this.step.getId(), this.step);
                consolidatedBatchStatus = BatchStatus.FAILED;
                if (this.analyzer != null && this.analyzerTxEnabled) {
                    try {
                        this.tm.rollback();
                    }
                    catch (Exception ee) {
                        BatchLogger.LOGGER.tracef(ee, "Exception when rolling back transaction.", new Object[0]);
                    }
                }
                if (this.reducer == null) break block40;
                this.reducer.rollbackPartitionedStep();
                this.reducer.afterPartitionedStepCompletion(PartitionReducer.PartitionStatus.ROLLBACK);
            }
        }
        ((StepContextImpl)this.batchContext).setBatchStatus(consolidatedBatchStatus);
        if (partitionHandler instanceof JobStopNotificationListener) {
            this.jobContext.getJobExecution().unregisterJobStopNotifier((JobStopNotificationListener)((Object)partitionHandler));
        }
        partitionHandler.close((StepContextImpl)this.batchContext);
    }

    private void initPartitionConfig() {
        Partition partition = this.step.getPartition();
        if (partition != null) {
            RefArtifact analyzerConfig;
            RefArtifact mapperConfig;
            this.isPartitioned = true;
            RefArtifact reducerConfig = partition.getReducer();
            if (reducerConfig != null) {
                this.reducer = (PartitionReducer)this.jobContext.createArtifact(reducerConfig.getRef(), null, reducerConfig.getProperties(), (StepContextImpl)this.batchContext);
            }
            if ((mapperConfig = partition.getMapper()) != null) {
                this.mapper = (PartitionMapper)this.jobContext.createArtifact(mapperConfig.getRef(), null, mapperConfig.getProperties(), (StepContextImpl)this.batchContext);
            }
            if ((analyzerConfig = partition.getAnalyzer()) != null) {
                this.analyzer = (PartitionAnalyzer)this.jobContext.createArtifact(analyzerConfig.getRef(), null, analyzerConfig.getProperties(), (StepContextImpl)this.batchContext);
            }
            this.plan = partition.getPlan();
        }
    }

    private void createStepListeners() {
        Listeners listeners = this.step.getListeners();
        if (listeners == null) {
            return;
        }
        for (RefArtifact listener : listeners.getListeners()) {
            String ref = listener.getRef();
            Class<?> cls = this.jobContext.getArtifactClass(ref);
            if (!StepListener.class.isAssignableFrom(cls)) continue;
            Object o = this.jobContext.createArtifact(ref, null, listener.getProperties(), (StepContextImpl)this.batchContext);
            this.stepListeners.add((StepListener)o);
        }
    }

    static TransactionManager getTransactionManager(JobContextImpl jobContext, Step step) {
        if (StepExecutionRunner.useLocalTx(jobContext, step)) {
            return LocalTransactionManager.getInstance();
        }
        return jobContext.getBatchEnvironment().getTransactionManager();
    }

    private static boolean useLocalTx(JobContextImpl jobContext, Step step) {
        String value;
        if (jobContext.getJobExecution().getJobParameters() != null && (value = jobContext.getJobExecution().getJobParameters().getProperty("jberet.local-tx")) != null) {
            return "true".equalsIgnoreCase(value);
        }
        if (step.getProperties() != null && (value = step.getProperties().get("jberet.local-tx")) != null) {
            return "true".equalsIgnoreCase(value);
        }
        if (jobContext.getJob().getProperties() != null && (value = jobContext.getJob().getProperties().get("jberet.local-tx")) != null) {
            return "true".equalsIgnoreCase(value);
        }
        return false;
    }

    private boolean loopAllowed() {
        String loopAllowedValue;
        Properties jobParameters = this.jobContext.getJobParameters();
        if (jobParameters != null && (loopAllowedValue = jobParameters.getProperty("jberet.loop.allowed")) != null) {
            return "true".equalsIgnoreCase(loopAllowedValue);
        }
        return false;
    }

    private static PartitionHandlerFactory getPartitionHandlerFactory() {
        PartitionHandlerFactory partitionHandlerFactory = WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(loaderAction) : loaderAction.run();
        return partitionHandlerFactory != null ? partitionHandlerFactory : ThreadPartitionHandlerFactory.getInstance();
    }
}

