/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mongojack.internal.update.ComplexUpdateOperationValue;
import org.mongojack.internal.update.MultiUpdateOperationValue;
import org.mongojack.internal.update.SingleUpdateOperationValue;
import org.mongojack.internal.update.UpdateOperationValue;
import org.mongojack.internal.util.SerializationUtils;

public class DBUpdate {
    public static Builder inc(String field) {
        return DBUpdate.inc(field, 1);
    }

    public static Builder inc(String field, int by) {
        return new Builder().inc(field, by);
    }

    public static Builder set(String field, Object value) {
        return new Builder().set(field, value);
    }

    public static Builder unset(String field) {
        return new Builder().unset(field);
    }

    public static Builder push(String field, Object value) {
        return new Builder().push(field, value);
    }

    public static Builder pushAll(String field, Object ... values) {
        return new Builder().pushAll(field, values);
    }

    public static Builder pushAll(String field, List<?> values) {
        return new Builder().pushAll(field, values);
    }

    public static Builder addToSet(String field, Object value) {
        return new Builder().addToSet(field, value);
    }

    public static Builder addToSet(String field, Object ... values) {
        return new Builder().addToSet(field, values);
    }

    public static Builder addToSet(String field, List<?> values) {
        return new Builder().addToSet(field, values);
    }

    public static Builder popFirst(String field) {
        return new Builder().popFirst(field);
    }

    public static Builder popLast(String field) {
        return new Builder().popLast(field);
    }

    public static Builder pull(String field, Object value) {
        return new Builder().pull(field, value);
    }

    public static Builder pullAll(String field, Object ... values) {
        return new Builder().pullAll(field, values);
    }

    public static Builder pullAll(String field, List<?> values) {
        return new Builder().pullAll(field, values);
    }

    public static Builder rename(String oldFieldName, String newFieldName) {
        return new Builder().rename(oldFieldName, newFieldName);
    }

    public static Builder bit(String field, String operation, int value) {
        return new Builder().bit(field, operation, value);
    }

    public static Builder bit(String field, String operation1, int value1, String operation2, int value2) {
        return new Builder().bit(field, operation1, value1, operation2, value2);
    }

    public static Builder bitwiseAnd(String field, int value) {
        return new Builder().bitwiseAnd(field, value);
    }

    public static Builder bitwiseOr(String field, int value) {
        return new Builder().bitwiseOr(field, value);
    }

    public static class Builder {
        private final Map<String, Map<String, UpdateOperationValue>> update = new HashMap<String, Map<String, UpdateOperationValue>>();

        public Builder inc(String field) {
            return this.inc(field, 1);
        }

        public Builder inc(String field, int by) {
            return this.addOperation("$inc", field, new SingleUpdateOperationValue(false, false, by));
        }

        public Builder set(String field, Object value) {
            return this.addOperation("$set", field, new SingleUpdateOperationValue(false, true, value));
        }

        public Builder unset(String field) {
            return this.addOperation("$unset", field, new SingleUpdateOperationValue(false, false, 1));
        }

        public Builder push(String field, Object value) {
            return this.addOperation("$push", field, new SingleUpdateOperationValue(true, true, value));
        }

        public Builder pushAll(String field, Object ... values) {
            return this.addOperation("$pushAll", field, new MultiUpdateOperationValue(true, true, values));
        }

        public Builder pushAll(String field, List<?> values) {
            return this.addOperation("$pushAll", field, new MultiUpdateOperationValue(true, true, values));
        }

        public Builder addToSet(String field, Object value) {
            return this.addOperation("$addToSet", field, new SingleUpdateOperationValue(true, true, value));
        }

        public Builder addToSet(String field, Object ... values) {
            return this.addOperation("$addToSet", field, new MultiUpdateOperationValue(true, true, values));
        }

        public Builder addToSet(String field, List<?> values) {
            return this.addOperation("$addToSet", field, new MultiUpdateOperationValue(true, true, values));
        }

        public Builder popFirst(String field) {
            return this.addOperation("$pop", field, new SingleUpdateOperationValue(true, false, -1));
        }

        public Builder popLast(String field) {
            return this.addOperation("$pop", field, new SingleUpdateOperationValue(true, false, 1));
        }

        public Builder pull(String field, Object value) {
            return this.addOperation("$pull", field, new SingleUpdateOperationValue(true, true, value));
        }

        public Builder pullAll(String field, Object ... values) {
            return this.addOperation("$pullAll", field, new MultiUpdateOperationValue(true, true, values));
        }

        public Builder pullAll(String field, List<?> values) {
            return this.addOperation("$pullAll", field, new MultiUpdateOperationValue(true, true, values));
        }

        public Builder rename(String oldFieldName, String newFieldName) {
            return this.addOperation("$rename", oldFieldName, new SingleUpdateOperationValue(false, false, newFieldName));
        }

        public Builder bit(String field, String operation, int value) {
            return this.addOperation("$bit", field, new ComplexUpdateOperationValue((DBObject)new BasicDBObject(operation, (Object)value)));
        }

        public Builder bit(String field, String operation1, int value1, String operation2, int value2) {
            return this.addOperation("$bit", field, new ComplexUpdateOperationValue((DBObject)new BasicDBObject(operation1, (Object)value1).append(operation2, (Object)value2)));
        }

        public Builder bitwiseAnd(String field, int value) {
            return this.bit(field, "and", value);
        }

        public Builder bitwiseOr(String field, int value) {
            return this.bit(field, "or", value);
        }

        public Builder addRawOperation(String op, String field, Object value) {
            return this.addOperation(op, field, new SingleUpdateOperationValue(false, false, value));
        }

        public Builder addOperation(String modifier, String field, UpdateOperationValue value) {
            if (this.update.containsKey(modifier)) {
                Map<String, UpdateOperationValue> existing = this.update.get(modifier);
                existing.put(field, value);
            } else {
                HashMap<String, UpdateOperationValue> newMap = new HashMap<String, UpdateOperationValue>();
                newMap.put(field, value);
                this.update.put(modifier, newMap);
            }
            return this;
        }

        public DBObject serialiseAndGet(ObjectMapper objectMapper, JavaType javaType) {
            return SerializationUtils.serializeDBUpdate(this.update, objectMapper, javaType);
        }

        public boolean isEmpty() {
            return this.update.isEmpty();
        }
    }
}

