/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.stream.csv;

import java.util.ArrayList;
import java.util.List;
import org.beanio.stream.RecordIOException;
import org.beanio.stream.RecordMarshaller;
import org.beanio.stream.RecordUnmarshaller;
import org.beanio.stream.csv.CsvParserConfiguration;

public class CsvRecordParser
implements RecordMarshaller,
RecordUnmarshaller {
    private char delim = (char)44;
    private char quote = (char)34;
    private char endQuote = (char)34;
    private char escape = (char)34;
    private boolean escapeEnabled = true;
    private boolean whitespaceAllowed = false;
    private boolean unquotedQuotesAllowed = false;
    private boolean alwaysQuote = false;
    private List<String> fieldList = new ArrayList<String>();

    public CsvRecordParser() {
        this(null);
    }

    public CsvRecordParser(CsvParserConfiguration config) {
        if (config == null) {
            config = new CsvParserConfiguration();
        }
        this.delim = config.getDelimiter();
        if (this.delim == ' ') {
            throw new IllegalArgumentException("The CSV field delimiter '" + this.delim + "' is not supported");
        }
        this.endQuote = this.quote = config.getQuote();
        if (this.quote == this.delim) {
            throw new IllegalArgumentException("The CSV field delimiter cannot match the character used for the quotation mark.");
        }
        this.whitespaceAllowed = config.isWhitespaceAllowed();
        this.unquotedQuotesAllowed = config.isUnquotedQuotesAllowed();
        if (config.getEscape() != null) {
            this.escapeEnabled = true;
            this.escape = config.getEscape().charValue();
            if (this.escape == this.delim) {
                throw new IllegalArgumentException("The CSV field delimiter cannot match the escape character.");
            }
        } else {
            this.escapeEnabled = false;
        }
        this.alwaysQuote = config.isAlwaysQuote();
    }

    public Object unmarshal(String text) throws RecordIOException {
        this.fieldList.clear();
        StringBuilder field = new StringBuilder();
        int state = 0;
        int whitespace = 0;
        boolean escaped = false;
        block11: for (char c : text.toCharArray()) {
            if (escaped) {
                escaped = false;
                if (c == this.endQuote || c == this.escape) {
                    field.append(c);
                    continue;
                }
                if (this.escape == this.endQuote) {
                    this.fieldList.add(field.toString());
                    field = new StringBuilder();
                    state = 10;
                }
            }
            switch (state) {
                case 0: {
                    if (c == this.delim) {
                        this.fieldList.add(this.createWhitespace(whitespace));
                        whitespace = 0;
                        continue block11;
                    }
                    if (c == this.quote) {
                        whitespace = 0;
                        state = 1;
                        continue block11;
                    }
                    if (c == ' ') {
                        if (!this.whitespaceAllowed) {
                            field.append(c);
                            state = 2;
                            continue block11;
                        }
                        ++whitespace;
                        continue block11;
                    }
                    field.append(this.createWhitespace(whitespace));
                    whitespace = 0;
                    field.append(c);
                    state = 2;
                    continue block11;
                }
                case 1: {
                    if (c == this.escape && this.escapeEnabled) {
                        escaped = true;
                        continue block11;
                    }
                    if (c == this.endQuote) {
                        this.fieldList.add(field.toString());
                        field = new StringBuilder();
                        state = 10;
                        continue block11;
                    }
                    field.append(c);
                    continue block11;
                }
                case 2: {
                    if (c == this.delim) {
                        this.fieldList.add(field.toString());
                        field = new StringBuilder();
                        state = 0;
                        continue block11;
                    }
                    if (c == this.quote && !this.unquotedQuotesAllowed) {
                        throw new RecordIOException("Quotation character '" + this.quote + "' must be quoted");
                    }
                    field.append(c);
                    continue block11;
                }
                case 10: {
                    if (c == ' ') {
                        if (this.whitespaceAllowed) continue block11;
                        throw new RecordIOException("Invalid whitespace found outside of a quoted field");
                    }
                    if (c == this.delim) {
                        state = 0;
                        continue block11;
                    }
                    throw new RecordIOException("Invalid character found outside of quoted field");
                }
            }
        }
        if (escaped && this.escape == this.endQuote) {
            this.fieldList.add(field.toString());
            state = 10;
        }
        switch (state) {
            case 0: {
                this.fieldList.add(this.createWhitespace(whitespace));
                break;
            }
            case 1: {
                throw new RecordIOException("Expected end quote before end of record");
            }
            case 2: {
                this.fieldList.add(field.toString());
                break;
            }
        }
        String[] record = new String[this.fieldList.size()];
        record = this.fieldList.toArray(record);
        return record;
    }

    public String marshal(Object record) {
        return this.marshal((String[])record);
    }

    public String marshal(String[] record) {
        StringBuilder text = new StringBuilder();
        int pos = 0;
        for (String field : record) {
            boolean quoted;
            if (pos++ > 0) {
                text.append(this.delim);
            }
            char[] cs = field.toCharArray();
            boolean bl = quoted = this.alwaysQuote || this.mustQuote(cs);
            if (quoted) {
                text.append(this.quote);
            }
            for (char c : cs) {
                if (c == this.endQuote || c == this.escape) {
                    text.append(this.escape);
                }
                text.append(c);
            }
            if (!quoted) continue;
            text.append(this.endQuote);
        }
        return text.toString();
    }

    private String createWhitespace(int size) {
        if (size == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            b.append(' ');
        }
        return b.toString();
    }

    private boolean mustQuote(char[] cs) {
        for (char c : cs) {
            if (c == this.delim) {
                return true;
            }
            if (c == this.quote) {
                return true;
            }
            if (c == '\n') {
                return true;
            }
            if (c != '\r') continue;
            return true;
        }
        return false;
    }
}

