/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.schedule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import javax.batch.operations.BatchRuntimeException;
import javax.ejb.Singleton;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.jberet.schedule.JobSchedule;
import org.jberet.schedule.JobScheduleConfig;
import org.jberet.schedule.JobScheduler;
import org.jberet.schedule._private.ScheduleExecutorMessages;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
public class TimerSchedulerBean
extends JobScheduler {
    @Resource
    private TimerService timerService;

    public JobSchedule schedule(JobScheduleConfig scheduleConfig) {
        Timer timer;
        JobSchedule jobSchedule = new JobSchedule(null, scheduleConfig);
        if (scheduleConfig.initialDelay > 0L) {
            timer = scheduleConfig.interval > 0L ? this.timerService.createIntervalTimer(TimerSchedulerBean.toMillis(scheduleConfig.initialDelay), TimerSchedulerBean.toMillis(scheduleConfig.interval), new TimerConfig((Serializable)jobSchedule, scheduleConfig.isPersistent())) : (scheduleConfig.afterDelay > 0L ? this.timerService.createIntervalTimer(TimerSchedulerBean.toMillis(scheduleConfig.initialDelay), TimerSchedulerBean.toMillis(scheduleConfig.afterDelay), new TimerConfig((Serializable)jobSchedule, scheduleConfig.isPersistent())) : this.timerService.createSingleActionTimer(TimerSchedulerBean.toMillis(scheduleConfig.initialDelay), new TimerConfig((Serializable)jobSchedule, scheduleConfig.isPersistent())));
        } else if (scheduleConfig.scheduleExpression != null) {
            timer = this.timerService.createCalendarTimer(scheduleConfig.scheduleExpression, new TimerConfig((Serializable)jobSchedule, scheduleConfig.isPersistent()));
        } else {
            throw ScheduleExecutorMessages.MESSAGES.invalidJobScheduleConfig(scheduleConfig);
        }
        jobSchedule.setId(TimerSchedulerBean.getTimerId(timer));
        return jobSchedule;
    }

    public List<JobSchedule> getJobSchedules() {
        ArrayList<JobSchedule> result = new ArrayList<JobSchedule>();
        Collection timers = this.timerService.getTimers();
        for (Timer t : timers) {
            Serializable info = t.getInfo();
            if (!(info instanceof JobSchedule)) continue;
            JobSchedule jobSchedule = (JobSchedule)info;
            if (jobSchedule.getId() == null) {
                jobSchedule.setId(TimerSchedulerBean.getTimerId(t));
            }
            result.add(jobSchedule);
        }
        Collections.sort(result, Collections.reverseOrder());
        return result;
    }

    public boolean cancel(String scheduleId) {
        Collection timers = this.timerService.getTimers();
        for (Timer t : timers) {
            if (!scheduleId.equals(TimerSchedulerBean.getTimerId(t))) continue;
            t.cancel();
            return true;
        }
        return false;
    }

    public JobSchedule getJobSchedule(String scheduleId) {
        Collection timers = this.timerService.getTimers();
        for (Timer e : timers) {
            JobSchedule js = (JobSchedule)e.getInfo();
            if (!scheduleId.equals(js.getId())) continue;
            return js;
        }
        return null;
    }

    public String[] getFeatures() {
        return new String[]{"persistent", "calendar"};
    }

    @Timeout
    protected void timeout(Timer timer) {
        JobSchedule jobSchedule = (JobSchedule)timer.getInfo();
        JobScheduleConfig scheduleConfig = jobSchedule.getJobScheduleConfig();
        if (scheduleConfig.getJobExecutionId() > 0L) {
            jobSchedule.addJobExecutionIds(JobScheduler.getJobOperator().restart(scheduleConfig.jobExecutionId, scheduleConfig.jobParameters));
        } else {
            jobSchedule.addJobExecutionIds(JobScheduler.getJobOperator().start(scheduleConfig.jobName, scheduleConfig.jobParameters));
        }
    }

    private static long toMillis(long t) {
        return JobScheduler.timeUnit.toMillis(t);
    }

    private static String getTimerId(Timer timer) {
        String s = timer.toString();
        int start = s.indexOf("id=");
        if (start < 0) {
            throw new BatchRuntimeException("Failed to get timer id: " + timer);
        }
        int end = s.indexOf(32, start += 3);
        return end > 0 ? s.substring(start, end) : s.substring(start);
    }
}

