/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.se;

import com.arjuna.ats.jta.UserTransaction;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jberet.se.BatchThreadFactory;
import org.jberet.se.SEArtifactFactory;
import org.jberet.spi.ArtifactFactory;
import org.jberet.spi.BatchEnvironment;
import org.jberet.util.BatchLogger;

public final class BatchSEEnvironment
implements BatchEnvironment {
    private static final ExecutorService executorService = Executors.newCachedThreadPool(new BatchThreadFactory());
    public static final String CONFIG_FILE_NAME = "jberet.properties";
    private volatile Properties configProperties;

    public ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = BatchSEEnvironment.class.getClassLoader();
        }
        return cl;
    }

    public ArtifactFactory getArtifactFactory() {
        return new SEArtifactFactory();
    }

    public Future<?> submitTask(Runnable task) {
        return executorService.submit(task);
    }

    public <T> Future<T> submitTask(Runnable task, T result) {
        return executorService.submit(task, result);
    }

    public <T> Future<T> submitTask(Callable<T> task) {
        return executorService.submit(task);
    }

    public javax.transaction.UserTransaction getUserTransaction() {
        return UserTransaction.userTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getBatchConfigurationProperties() {
        Properties result = this.configProperties;
        if (result == null) {
            BatchSEEnvironment batchSEEnvironment = this;
            synchronized (batchSEEnvironment) {
                result = this.configProperties;
                if (result == null) {
                    result = new Properties();
                    InputStream configStream = this.getClassLoader().getResourceAsStream(CONFIG_FILE_NAME);
                    if (configStream != null) {
                        try {
                            result.load(configStream);
                        }
                        catch (IOException e) {
                            throw BatchLogger.LOGGER.failToLoadConfig((Throwable)e, CONFIG_FILE_NAME);
                        }
                    } else {
                        BatchLogger.LOGGER.useDefaultJBeretConfig(CONFIG_FILE_NAME);
                    }
                    this.configProperties = result;
                }
            }
        }
        return result;
    }
}

