/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.se;

import jakarta.transaction.TransactionManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jberet.repository.JobRepository;
import org.jberet.se.BatchThreadFactory;
import org.jberet.se.ClassPathJobXmlResolver;
import org.jberet.se.JobRepositoryFactory;
import org.jberet.se.SEArtifactFactory;
import org.jberet.se._private.SEBatchLogger;
import org.jberet.se._private.SEBatchMessages;
import org.jberet.spi.ArtifactFactory;
import org.jberet.spi.BatchEnvironment;
import org.jberet.spi.JobExecutor;
import org.jberet.spi.JobTask;
import org.jberet.spi.JobXmlResolver;
import org.jberet.tools.ChainedJobXmlResolver;
import org.jberet.tools.MetaInfBatchJobsJobXmlResolver;
import org.jberet.tx.LocalTransactionManager;

public final class BatchSEEnvironment
implements BatchEnvironment {
    public static final String CONFIG_FILE_NAME = "jberet.properties";
    public static final String JOB_REPOSITORY_TYPE_KEY = "job-repository-type";
    public static final String REPOSITORY_TYPE_IN_MEMORY = "in-memory";
    public static final String REPOSITORY_TYPE_JDBC = "jdbc";
    public static final String REPOSITORY_TYPE_MONGODB = "mongodb";
    public static final String REPOSITORY_TYPE_INFINISPAN = "infinispan";
    private static final JobXmlResolver[] DEFAULT_JOB_XML_RESOLVERS = new JobXmlResolver[]{new ClassPathJobXmlResolver(), new MetaInfBatchJobsJobXmlResolver()};
    private final Properties configProperties = new Properties();
    private final TransactionManager tm;
    private final JobXmlResolver jobXmlResolver;
    private final JobExecutor executor;
    static final String THREAD_POOL_TYPE = "thread-pool-type";
    static final String THREAD_POOL_TYPE_CACHED = "Cached";
    static final String THREAD_POOL_TYPE_FIXED = "Fixed";
    static final String THREAD_POOL_TYPE_CONFIGURED = "Configured";
    static final String THREAD_POOL_CORE_SIZE = "thread-pool-core-size";
    static final String THREAD_POOL_MAX_SIZE = "thread-pool-max-size";
    static final String THREAD_POOL_KEEP_ALIVE_TIME = "thread-pool-keep-alive-time";
    static final String THREAD_POOL_QUEUE_CAPACITY = "thread-pool-queue-capacity";
    static final String THREAD_POOL_ALLOW_CORE_THREAD_TIMEOUT = "thread-pool-allow-core-thread-timeout";
    static final String THREAD_POOL_PRESTART_ALL_CORE_THREADS = "thread-pool-prestart-all-core-threads";
    static final String THREAD_POOL_REJECTION_POLICY = "thread-pool-rejection-policy";
    static final String THREAD_FACTORY = "thread-factory";

    public BatchSEEnvironment() {
        InputStream configStream = this.getClassLoader().getResourceAsStream(CONFIG_FILE_NAME);
        if (configStream != null) {
            try {
                this.configProperties.load(configStream);
            }
            catch (IOException e) {
                throw SEBatchMessages.MESSAGES.failToLoadConfig(e, CONFIG_FILE_NAME);
            }
            finally {
                try {
                    configStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        SEBatchLogger.LOGGER.useDefaultJBeretConfig(CONFIG_FILE_NAME);
        this.tm = LocalTransactionManager.getInstance();
        final ThreadPoolExecutor threadPoolExecutor = this.createThreadPoolExecutor();
        this.executor = new JobExecutor(threadPoolExecutor){

            protected int getMaximumPoolSize() {
                return threadPoolExecutor.getMaximumPoolSize();
            }
        };
        ServiceLoader<JobXmlResolver> userJobXmlResolvers = ServiceLoader.load(JobXmlResolver.class, this.getClassLoader());
        this.jobXmlResolver = new ChainedJobXmlResolver(userJobXmlResolvers, DEFAULT_JOB_XML_RESOLVERS);
    }

    public ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = BatchSEEnvironment.class.getClassLoader();
        }
        return cl;
    }

    public ArtifactFactory getArtifactFactory() {
        return new SEArtifactFactory();
    }

    public void submitTask(JobTask task) {
        this.executor.execute(task);
    }

    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    public JobRepository getJobRepository() {
        return JobRepositoryFactory.getJobRepository(this.configProperties);
    }

    public JobXmlResolver getJobXmlResolver() {
        return this.jobXmlResolver;
    }

    public Properties getBatchConfigurationProperties() {
        return this.configProperties;
    }

    public String getApplicationName() {
        return null;
    }

    ThreadPoolExecutor createThreadPoolExecutor() {
        int coreSize;
        ThreadFactory threadFactory;
        String threadPoolType = this.configProperties.getProperty(THREAD_POOL_TYPE);
        String threadFactoryProp = this.configProperties.getProperty(THREAD_FACTORY);
        if (threadFactoryProp != null && !threadFactoryProp.isEmpty()) {
            try {
                Class<?> threadFactoryClass = this.getClassLoader().loadClass(threadFactoryProp.trim());
                threadFactory = (ThreadFactory)threadFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw SEBatchMessages.MESSAGES.failToGetConfigProperty(THREAD_FACTORY, threadFactoryProp, e);
            }
        } else {
            threadFactory = new BatchThreadFactory();
        }
        if (threadPoolType == null || threadPoolType.isEmpty() || threadPoolType.trim().equalsIgnoreCase(THREAD_POOL_TYPE_CACHED)) {
            return (ThreadPoolExecutor)Executors.newCachedThreadPool(threadFactory);
        }
        String coreSizeProp = this.configProperties.getProperty(THREAD_POOL_CORE_SIZE);
        try {
            coreSize = Integer.parseInt(coreSizeProp.trim());
        }
        catch (Exception e) {
            throw SEBatchMessages.MESSAGES.failToGetConfigProperty(THREAD_POOL_CORE_SIZE, coreSizeProp, e);
        }
        threadPoolType = threadPoolType.trim();
        if (threadPoolType.equalsIgnoreCase(THREAD_POOL_TYPE_FIXED)) {
            return (ThreadPoolExecutor)Executors.newFixedThreadPool(coreSize, threadFactory);
        }
        if (threadPoolType.equalsIgnoreCase(THREAD_POOL_TYPE_CONFIGURED)) {
            ThreadPoolExecutor threadPoolExecutor;
            int queueCapacity;
            long keepAliveSeconds;
            int maxSize;
            String maxSizeProp = this.configProperties.getProperty(THREAD_POOL_MAX_SIZE);
            try {
                maxSize = Integer.parseInt(maxSizeProp.trim());
            }
            catch (Exception e) {
                throw SEBatchMessages.MESSAGES.failToGetConfigProperty(THREAD_POOL_MAX_SIZE, maxSizeProp, e);
            }
            String keepAliveProp = this.configProperties.getProperty(THREAD_POOL_KEEP_ALIVE_TIME);
            try {
                keepAliveSeconds = Long.parseLong(keepAliveProp.trim());
            }
            catch (Exception e) {
                throw SEBatchMessages.MESSAGES.failToGetConfigProperty(THREAD_POOL_KEEP_ALIVE_TIME, keepAliveProp, e);
            }
            String queueCapacityProp = this.configProperties.getProperty(THREAD_POOL_QUEUE_CAPACITY);
            try {
                queueCapacity = Integer.parseInt(queueCapacityProp.trim());
            }
            catch (Exception e) {
                throw SEBatchMessages.MESSAGES.failToGetConfigProperty(THREAD_POOL_QUEUE_CAPACITY, queueCapacityProp, e);
            }
            String allowCoreThreadTimeoutProp = this.configProperties.getProperty(THREAD_POOL_ALLOW_CORE_THREAD_TIMEOUT);
            boolean allowCoreThreadTimeout = allowCoreThreadTimeoutProp == null || allowCoreThreadTimeoutProp.isEmpty() ? false : Boolean.parseBoolean(allowCoreThreadTimeoutProp.trim());
            String prestartAllCoreThreadsProp = this.configProperties.getProperty(THREAD_POOL_PRESTART_ALL_CORE_THREADS);
            boolean prestartAllCoreThreads = prestartAllCoreThreadsProp == null || prestartAllCoreThreadsProp.isEmpty() ? false : Boolean.parseBoolean(prestartAllCoreThreadsProp.trim());
            LinkedBlockingQueue<Runnable> workQueue = queueCapacity > 0 ? new LinkedBlockingQueue(queueCapacity) : new SynchronousQueue(true);
            String rejectionPolicyProp = this.configProperties.getProperty(THREAD_POOL_REJECTION_POLICY);
            RejectedExecutionHandler rejectionHandler = null;
            if (rejectionPolicyProp != null && !rejectionPolicyProp.isEmpty()) {
                try {
                    Class<?> aClass = this.getClassLoader().loadClass(rejectionPolicyProp.trim());
                    rejectionHandler = (RejectedExecutionHandler)aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw SEBatchMessages.MESSAGES.failToGetConfigProperty(THREAD_POOL_REJECTION_POLICY, rejectionPolicyProp, e);
                }
            }
            ThreadPoolExecutor threadPoolExecutor2 = threadPoolExecutor = rejectionHandler == null ? new ThreadPoolExecutor(coreSize, maxSize, keepAliveSeconds, TimeUnit.SECONDS, workQueue, threadFactory) : new ThreadPoolExecutor(coreSize, maxSize, keepAliveSeconds, TimeUnit.SECONDS, workQueue, threadFactory, rejectionHandler);
            if (allowCoreThreadTimeout) {
                threadPoolExecutor.allowCoreThreadTimeOut(true);
            }
            if (prestartAllCoreThreads) {
                threadPoolExecutor.prestartAllCoreThreads();
            }
            return threadPoolExecutor;
        }
        throw SEBatchMessages.MESSAGES.failToGetConfigProperty(THREAD_POOL_TYPE, threadPoolType, null);
    }
}

