/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support._private;

import java.io.File;
import javax.batch.operations.BatchRuntimeException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="JBERET")
@ValidIdRange(min=60000, max=60999)
public interface SupportLogger
extends BasicLogger {
    public static final SupportLogger LOGGER = (SupportLogger)Logger.getMessageLogger(SupportLogger.class, (String)"org.jberet.support");

    @Message(id=60000, value="Invalid CSV preference value %s for key %s")
    public BatchRuntimeException invalidCsvPreference(String var1, String var2);

    @Message(id=60001, value="Failed to read header from CSV resource %s")
    public BatchRuntimeException failToReadCsvHeader(@Cause Throwable var1, String var2);

    @Message(id=60002, value="Failed to load or instantiate custom type based on property value %s")
    public BatchRuntimeException failToLoadOrCreateCustomType(@Cause Throwable var1, String var2);

    @Message(id=60003, value="Invalid property value format (missing quote): %s")
    public BatchRuntimeException missingQuote(String var1);

    @Message(id=60004, value="Failed to open stream from resource: %s")
    public BatchRuntimeException failToOpenStream(@Cause Throwable var1, String var2);

    @Message(id=60005, value="Invalid position %s to start reading, the configured range is between %s and %s")
    public BatchRuntimeException invalidStartPosition(int var1, int var2, int var3);

    @Message(id=60006, value="The number of CellProcessor %s and the number of headers %s are different.")
    public BatchRuntimeException numberOfCellProcessorsAndHeaderDiff(int var1, int var2);

    @Message(id=60007, value="Unexpected character %s at position %s in character array %s")
    public BatchRuntimeException unexpectedChar(char var1, int var2, String var3);

    @Message(id=60008, value="Invalid parameters for CellProcessor: %s %s")
    public BatchRuntimeException invalidParamsForCellProcessor(String var1, String[] var2);

    @Message(id=60009, value="Unsupported CellProcessor: %s %s")
    public BatchRuntimeException unsupportedCellProcessor(String var1, String[] var2);

    @Message(id=60010, value="The target CSV resource already exists: %s")
    public BatchRuntimeException csvResourceAlreadyExists(Object var1);

    @Message(id=60011, value="The target CSV resource is a directory: %s")
    public BatchRuntimeException csvResourceIsDirectory(File var1);

    @Message(id=60012, value="The existing transient user data in step is not of type String: %s")
    public BatchRuntimeException cannotAppendToNonStringData(Class<?> var1);

    @Message(id=60013, value="The CellProcessor value may be missing an ending single quote: %s")
    @LogMessage(level=Logger.Level.WARN)
    public void maybeMissingEndQuote(String var1);
}

