/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemWriter;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.jberet.support._private.SupportLogger;
import org.jberet.support.io.CsvItemReaderWriterBase;
import org.supercsv.io.CsvBeanWriter;
import org.supercsv.io.CsvListWriter;
import org.supercsv.io.CsvMapWriter;
import org.supercsv.io.ICsvBeanWriter;
import org.supercsv.io.ICsvListWriter;
import org.supercsv.io.ICsvMapWriter;
import org.supercsv.io.ICsvWriter;

@Named
public class CsvItemWriter
extends CsvItemReaderWriterBase
implements ItemWriter {
    @Inject
    protected StepContext stepContext;
    @Inject
    @BatchProperty
    protected String[] header;
    @Inject
    @BatchProperty
    protected String writeComments;
    @Inject
    @BatchProperty
    protected String writeMode;
    private StringWriter stringWriter;
    protected ICsvWriter delegateWriter;
    private boolean skipWritingHeader;

    public void open(Serializable checkpoint) throws Exception {
        SupportLogger.LOGGER.tracef("Open CsvItemWriter with checkpoint %s, which is ignored for CsvItemWriter.%n", checkpoint);
        if (this.beanType == null) {
            throw SupportLogger.LOGGER.invalidCsvPreference(null, "beanType");
        }
        this.delegateWriter = List.class.isAssignableFrom(this.beanType) ? new CsvListWriter(this.getOutputWriter(), this.getCsvPreference()) : (Map.class.isAssignableFrom(this.beanType) ? new CsvMapWriter(this.getOutputWriter(), this.getCsvPreference()) : new CsvBeanWriter(this.getOutputWriter(), this.getCsvPreference()));
        if (this.header == null) {
            throw SupportLogger.LOGGER.invalidCsvPreference(null, "header");
        }
        if (this.nameMapping == null) {
            this.nameMapping = this.header;
        }
        this.cellProcessorInstances = this.getCellProcessors();
        if (this.writeComments != null) {
            this.delegateWriter.writeComment(this.writeComments);
        }
        if (!this.skipWritingHeader) {
            this.delegateWriter.writeHeader(this.header);
        }
    }

    public void close() throws Exception {
        if (this.delegateWriter != null) {
            if (this.resource.equalsIgnoreCase("StepContext")) {
                Object transientUserData = this.stepContext.getTransientUserData();
                if ("overwrite".equalsIgnoreCase(this.writeMode) || transientUserData == null) {
                    this.stepContext.setTransientUserData((Object)this.stringWriter.toString());
                } else {
                    this.stepContext.setTransientUserData((Object)(transientUserData + this.getCsvPreference().getEndOfLineSymbols() + this.stringWriter.toString()));
                }
                this.stringWriter = null;
            }
            this.delegateWriter.close();
            this.delegateWriter = null;
        }
    }

    public void writeItems(List<Object> items) throws Exception {
        if (SupportLogger.LOGGER.isTraceEnabled()) {
            SupportLogger.LOGGER.tracef("About to write items, number of items %s, element type %s%n", items.size(), items.get(0).getClass());
        }
        if (this.delegateWriter instanceof ICsvBeanWriter) {
            ICsvBeanWriter writer = (ICsvBeanWriter)this.delegateWriter;
            if (this.cellProcessorInstances.length == 0) {
                for (Object e : items) {
                    writer.write(e, this.nameMapping);
                }
            } else {
                for (Object e : items) {
                    writer.write(e, this.nameMapping, this.cellProcessorInstances);
                }
            }
        } else if (this.delegateWriter instanceof ICsvMapWriter) {
            ICsvMapWriter writer = (ICsvMapWriter)this.delegateWriter;
            if (this.cellProcessorInstances.length == 0) {
                for (Object e : items) {
                    writer.write((Map)e, this.nameMapping);
                }
            } else {
                for (Object e : items) {
                    writer.write((Map)e, this.nameMapping, this.cellProcessorInstances);
                }
            }
        } else if (this.delegateWriter instanceof ICsvListWriter) {
            ICsvListWriter writer = (ICsvListWriter)this.delegateWriter;
            if (this.cellProcessorInstances.length == 0) {
                for (Object e : items) {
                    writer.write((List)e);
                }
            } else {
                for (Object e : items) {
                    writer.write((List)e, this.cellProcessorInstances);
                }
            }
        }
        this.delegateWriter.flush();
    }

    public Serializable checkpointInfo() throws Exception {
        return Integer.valueOf(this.delegateWriter.getRowNumber());
    }

    protected Writer getOutputWriter() {
        if (this.resource == null) {
            throw SupportLogger.LOGGER.invalidCsvPreference(this.resource, "resource");
        }
        if (this.resource.equalsIgnoreCase("StepContext")) {
            if ("overwrite".equalsIgnoreCase(this.writeMode)) {
                this.stringWriter = new StringWriter();
                return this.stringWriter;
            }
            Object transientUserData = this.stepContext.getTransientUserData();
            if (this.writeMode == null || this.writeMode.equalsIgnoreCase("append")) {
                if (transientUserData != null) {
                    if (transientUserData instanceof String) {
                        this.skipWritingHeader = true;
                    } else {
                        throw SupportLogger.LOGGER.cannotAppendToNonStringData(transientUserData.getClass());
                    }
                }
                this.stringWriter = new StringWriter();
                return this.stringWriter;
            }
            if (this.writeMode.equalsIgnoreCase("failIfExists")) {
                if (transientUserData != null) {
                    throw SupportLogger.LOGGER.csvResourceAlreadyExists(transientUserData);
                }
                this.stringWriter = new StringWriter();
                return this.stringWriter;
            }
            throw SupportLogger.LOGGER.invalidCsvPreference(this.writeMode, "writeMode");
        }
        try {
            File file = new File(this.resource);
            boolean exists = file.exists();
            if (exists && file.isDirectory()) {
                throw SupportLogger.LOGGER.csvResourceIsDirectory(file);
            }
            if (this.writeMode == null || this.writeMode.equalsIgnoreCase("append")) {
                if (file.length() > 0L) {
                    this.skipWritingHeader = true;
                }
                return new FileWriter(file, true);
            }
            if (this.writeMode.equalsIgnoreCase("overwrite")) {
                return new FileWriter(file);
            }
            if (this.writeMode.equalsIgnoreCase("failIfExists")) {
                if (exists) {
                    throw SupportLogger.LOGGER.csvResourceAlreadyExists(file.getPath());
                }
                return new FileWriter(this.resource);
            }
            throw SupportLogger.LOGGER.invalidCsvPreference(this.writeMode, "writeMode");
        }
        catch (IOException e) {
            throw SupportLogger.LOGGER.invalidCsvPreference(this.resource, "resource");
        }
    }
}

