/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.batch.api.BatchProperty;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import org.jberet.support._private.SupportLogger;
import org.jberet.support.io.UnicodeBOMInputStream;

public abstract class ItemReaderWriterBase {
    @Inject
    @BatchProperty
    protected String resource;
    boolean skipWritingHeader;
    StringWriter stringWriter;

    protected Reader getInputReader(boolean detectBOM) {
        InputStreamReader result;
        if (this.resource == null) {
            throw SupportLogger.LOGGER.invalidReaderWriterProperty(this.resource, "resource");
        }
        try {
            InputStream inputStream;
            try {
                URL url = new URL(this.resource);
                inputStream = url.openStream();
            }
            catch (MalformedURLException e) {
                SupportLogger.LOGGER.tracef("The resource %s is not a URL, %s%n", this.resource, e);
                File file = new File(this.resource);
                if (file.exists()) {
                    inputStream = new FileInputStream(file);
                }
                SupportLogger.LOGGER.tracef("The resource %s is not a file %n", this.resource);
                inputStream = ItemReaderWriterBase.class.getClassLoader().getResourceAsStream(this.resource);
            }
            if (detectBOM) {
                UnicodeBOMInputStream bomin = new UnicodeBOMInputStream(inputStream);
                bomin.skipBOM();
                result = new InputStreamReader(bomin);
            } else {
                result = new InputStreamReader(inputStream);
            }
        }
        catch (IOException e) {
            throw SupportLogger.LOGGER.failToOpenStream(e, this.resource);
        }
        return result;
    }

    protected Writer getOutputWriter(String writeMode, StepContext stepContext) {
        if (this.resource == null) {
            throw SupportLogger.LOGGER.invalidReaderWriterProperty(this.resource, "resource");
        }
        if (this.resource.equalsIgnoreCase("StepContext")) {
            if ("overwrite".equalsIgnoreCase(writeMode)) {
                this.stringWriter = new StringWriter();
                return this.stringWriter;
            }
            Object transientUserData = stepContext.getTransientUserData();
            if (writeMode == null || writeMode.equalsIgnoreCase("append")) {
                if (transientUserData != null) {
                    if (transientUserData instanceof String) {
                        this.skipWritingHeader = true;
                    } else {
                        throw SupportLogger.LOGGER.cannotAppendToNonStringData(transientUserData.getClass());
                    }
                }
                this.stringWriter = new StringWriter();
                return this.stringWriter;
            }
            if (writeMode.equalsIgnoreCase("failIfExists")) {
                if (transientUserData != null) {
                    throw SupportLogger.LOGGER.writerResourceAlreadyExists(transientUserData);
                }
                this.stringWriter = new StringWriter();
                return this.stringWriter;
            }
            throw SupportLogger.LOGGER.invalidReaderWriterProperty(writeMode, "writeMode");
        }
        try {
            File file = new File(this.resource);
            boolean exists = file.exists();
            if (exists && file.isDirectory()) {
                throw SupportLogger.LOGGER.writerResourceIsDirectory(file);
            }
            if (writeMode == null || writeMode.equalsIgnoreCase("append")) {
                FileWriter fw = new FileWriter(file, true);
                if (file.length() > 0L) {
                    this.skipWritingHeader = true;
                    fw.write("\n\n");
                }
                return fw;
            }
            if (writeMode.equalsIgnoreCase("overwrite")) {
                return new FileWriter(file);
            }
            if (writeMode.equalsIgnoreCase("failIfExists")) {
                if (exists) {
                    throw SupportLogger.LOGGER.writerResourceAlreadyExists(file.getPath());
                }
                return new FileWriter(this.resource);
            }
            throw SupportLogger.LOGGER.invalidReaderWriterProperty(writeMode, "writeMode");
        }
        catch (IOException e) {
            throw SupportLogger.LOGGER.invalidReaderWriterProperty(this.resource, "resource");
        }
    }
}

