/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.batch.api.BatchProperty;
import javax.inject.Inject;
import org.jberet.support._private.SupportLogger;
import org.jberet.support.io.ItemReaderWriterBase;

public abstract class JsonItemReaderWriterBase
extends ItemReaderWriterBase {
    @Inject
    @BatchProperty
    protected Map<String, String> jsonFactoryFeatures;
    @Inject
    @BatchProperty
    protected Map<String, String> mapperFeatures;
    protected JsonFactory jsonFactory;
    protected ObjectMapper objectMapper;

    protected abstract void registerModule() throws Exception;

    protected void initJsonFactory() {
        JsonFactory.Feature feature;
        String value;
        String key;
        this.jsonFactory = new MappingJsonFactory();
        if (this.jsonFactoryFeatures != null) {
            for (Map.Entry<String, String> e : this.jsonFactoryFeatures.entrySet()) {
                key = e.getKey();
                value = e.getValue();
                try {
                    feature = JsonFactory.Feature.valueOf((String)key);
                }
                catch (Exception e1) {
                    throw SupportLogger.LOGGER.unrecognizedReaderWriterProperty(key, value);
                }
                if ("true".equals(value)) {
                    if (feature.enabledByDefault()) continue;
                    this.jsonFactory.configure(feature, true);
                    continue;
                }
                if ("false".equals(value)) {
                    if (!feature.enabledByDefault()) continue;
                    this.jsonFactory.configure(feature, false);
                    continue;
                }
                throw SupportLogger.LOGGER.invalidReaderWriterProperty(value, key);
            }
        }
        if (this.mapperFeatures != null) {
            this.objectMapper = new ObjectMapper(this.jsonFactory);
            for (Map.Entry<String, String> e : this.mapperFeatures.entrySet()) {
                key = e.getKey();
                value = e.getValue();
                try {
                    feature = MapperFeature.valueOf((String)key);
                }
                catch (Exception e1) {
                    throw SupportLogger.LOGGER.unrecognizedReaderWriterProperty(key, value);
                }
                if ("true".equals(value)) {
                    if (feature.enabledByDefault()) continue;
                    this.objectMapper.configure((MapperFeature)feature, true);
                    continue;
                }
                if ("false".equals(value)) {
                    if (!feature.enabledByDefault()) continue;
                    this.objectMapper.configure((MapperFeature)feature, false);
                    continue;
                }
                throw SupportLogger.LOGGER.invalidReaderWriterProperty(value, key);
            }
        }
    }
}

