/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.io.OutputDecorator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.Serializable;
import java.util.List;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemWriter;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.stream.XMLStreamWriter;
import org.jberet.support._private.SupportLogger;
import org.jberet.support.io.XmlItemReaderWriterBase;

@Named
public class XmlItemWriter
extends XmlItemReaderWriterBase
implements ItemWriter {
    protected static final String NEW_LINE = System.getProperty("line.separator");
    @Inject
    protected StepContext stepContext;
    @Inject
    @BatchProperty
    protected String writeMode;
    @Inject
    @BatchProperty
    protected String defaultUseWrapper;
    @Inject
    @BatchProperty
    protected String rootElementName;
    @Inject
    @BatchProperty
    protected String rootElementPrefix;
    @Inject
    @BatchProperty
    protected String rootElementNamespaceURI;
    @Inject
    @BatchProperty
    protected Class prettyPrinter;
    @Inject
    @BatchProperty
    protected Class outputDecorator;
    protected ToXmlGenerator toXmlGenerator;
    private XMLStreamWriter staxWriter;

    public void open(Serializable checkpoint) throws Exception {
        SupportLogger.LOGGER.tracef("Open XmlItemWriter with checkpoint %s, which is ignored for XmlItemWriter.%n", checkpoint);
        super.initXmlFactory();
        if (this.outputDecorator != null) {
            this.xmlFactory.setOutputDecorator((OutputDecorator)this.outputDecorator.newInstance());
        }
        this.xmlMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        this.toXmlGenerator = this.xmlFactory.createGenerator(this.getOutputWriter(this.writeMode, this.stepContext));
        this.toXmlGenerator.setCodec((ObjectCodec)this.xmlMapper);
        SupportLogger.LOGGER.openingResource(this.resource, this.getClass());
        if (this.prettyPrinter == null) {
            this.toXmlGenerator.useDefaultPrettyPrinter();
        } else {
            this.toXmlGenerator.setPrettyPrinter((PrettyPrinter)this.prettyPrinter.newInstance());
        }
        this.staxWriter = this.toXmlGenerator.getStaxWriter();
        this.staxWriter.writeStartDocument();
        this.staxWriter.writeCharacters(NEW_LINE);
        if (this.rootElementName == null || this.rootElementName.isEmpty()) {
            throw SupportLogger.LOGGER.invalidReaderWriterProperty(this.rootElementName, "rootElementName");
        }
        if (this.rootElementPrefix == null || this.rootElementPrefix.isEmpty()) {
            if (this.rootElementNamespaceURI == null || this.rootElementNamespaceURI.isEmpty()) {
                this.staxWriter.writeStartElement(this.rootElementName);
            } else {
                this.staxWriter.writeStartElement(this.rootElementNamespaceURI, this.rootElementName);
            }
        } else {
            if (this.rootElementNamespaceURI == null || this.rootElementNamespaceURI.isEmpty()) {
                throw SupportLogger.LOGGER.invalidReaderWriterProperty(this.rootElementNamespaceURI, "rootElementNamespaceURI");
            }
            this.staxWriter.writeStartElement(this.rootElementPrefix, this.rootElementName, this.rootElementNamespaceURI);
        }
    }

    public void writeItems(List<Object> items) throws Exception {
        for (Object o : items) {
            this.staxWriter.writeCharacters(NEW_LINE);
            this.toXmlGenerator.writeObject(o);
        }
        this.toXmlGenerator.flush();
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }

    public void close() throws Exception {
        if (this.toXmlGenerator != null) {
            SupportLogger.LOGGER.closingResource(this.resource, this.getClass());
            this.staxWriter.writeCharacters(NEW_LINE);
            this.staxWriter.writeEndDocument();
            this.toXmlGenerator.close();
            this.toXmlGenerator = null;
            if (this.resource.equalsIgnoreCase("StepContext")) {
                Object transientUserData = this.stepContext.getTransientUserData();
                if ("overwrite".equalsIgnoreCase(this.writeMode) || transientUserData == null) {
                    this.stepContext.setTransientUserData((Object)this.stringWriter.toString());
                } else {
                    this.stepContext.setTransientUserData((Object)(transientUserData + this.stringWriter.toString()));
                }
                this.stringWriter = null;
            }
        }
    }

    @Override
    protected void initXmlModule() {
        if (this.defaultUseWrapper != null) {
            if (this.defaultUseWrapper.equals("false")) {
                this.xmlModule = new JacksonXmlModule();
                this.xmlModule.setDefaultUseWrapper(false);
            } else if (!this.defaultUseWrapper.equals("true")) {
                throw SupportLogger.LOGGER.invalidReaderWriterProperty(this.defaultUseWrapper, "defaultUseWrapper");
            }
        }
    }
}

