/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.batch.api.BatchProperty;
import javax.inject.Inject;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.UnicodeBOMInputStream;

public abstract class ItemReaderWriterBase {
    protected static final String NEW_LINE = System.getProperty("line.separator");
    @Inject
    @BatchProperty
    protected String resource;
    boolean skipWritingHeader;

    protected static InputStream getInputStream(String inputResource, boolean detectBOM) {
        InputStream inputStream;
        if (inputResource == null) {
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, null, "resource");
        }
        try {
            try {
                URL url = new URL(inputResource);
                inputStream = url.openStream();
            }
            catch (MalformedURLException e) {
                SupportLogger.LOGGER.tracef("The resource %s is not a URL, %s%n", inputResource, e);
                File file = new File(inputResource);
                if (file.exists()) {
                    inputStream = new FileInputStream(file);
                }
                SupportLogger.LOGGER.tracef("The resource %s is not a file %n", inputResource);
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = ItemReaderWriterBase.class.getClassLoader();
                }
                inputStream = cl.getResourceAsStream(inputResource);
            }
            if (detectBOM) {
                UnicodeBOMInputStream bomin = new UnicodeBOMInputStream(inputStream);
                bomin.skipBOM();
                return bomin;
            }
        }
        catch (IOException e) {
            throw SupportMessages.MESSAGES.failToOpenStream(e, inputResource);
        }
        return inputStream;
    }

    protected OutputStream getOutputStream(String writeMode) {
        if (this.resource == null) {
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, null, "resource");
        }
        try {
            File file = new File(this.resource);
            boolean exists = file.exists();
            if (writeMode == null || writeMode.equalsIgnoreCase("append")) {
                FileOutputStream fos = new FileOutputStream(file, true);
                if (file.length() > 0L) {
                    this.skipWritingHeader = true;
                    fos.write(NEW_LINE.getBytes());
                }
                return fos;
            }
            if (writeMode.equalsIgnoreCase("overwrite")) {
                return new FileOutputStream(file);
            }
            if (writeMode.equalsIgnoreCase("failIfExists")) {
                if (exists) {
                    throw SupportMessages.MESSAGES.writerResourceAlreadyExists(file.getPath());
                }
                return new FileOutputStream(file);
            }
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, writeMode, "writeMode");
        }
        catch (IOException e) {
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(e, this.resource, "resource");
        }
    }
}

