/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import javax.batch.api.BatchProperty;
import javax.inject.Inject;
import javax.naming.InitialContext;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.MongoClientObjectFactory;
import org.mongojack.JacksonDBCollection;

public abstract class MongoItemReaderWriterBase {
    @Inject
    @BatchProperty
    protected Class beanType;
    @Inject
    @BatchProperty
    protected String mongoClientLookup;
    @Inject
    @BatchProperty
    protected String uri;
    @Inject
    @BatchProperty
    protected String host;
    @Inject
    @BatchProperty
    protected String database;
    @Inject
    @BatchProperty
    protected String user;
    @Inject
    @BatchProperty
    protected String password;
    @Inject
    @BatchProperty
    protected String options;
    @Inject
    @BatchProperty
    protected String collection;
    protected MongoClient mongoClient;
    protected DB db;
    protected JacksonDBCollection<Object, String> jacksonCollection;

    protected void init() throws Exception {
        if (this.beanType == null) {
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, null, "beanType");
        }
        if (this.mongoClientLookup == null) {
            MongoClientURI clientURI;
            if (this.uri != null) {
                clientURI = new MongoClientURI(this.uri);
                if (this.database == null) {
                    this.database = clientURI.getDatabase();
                }
                if (this.collection == null) {
                    this.collection = clientURI.getCollection();
                }
            } else {
                clientURI = MongoClientObjectFactory.createMongoClientURI(this.host, this.database, this.collection, this.options, this.user, this.password);
            }
            this.mongoClient = (MongoClient)Mongo.Holder.singleton().connect(clientURI);
        } else {
            this.mongoClient = (MongoClient)InitialContext.doLookup(this.mongoClientLookup);
        }
        this.db = this.mongoClient.getDB(this.database);
        this.jacksonCollection = JacksonDBCollection.wrap((DBCollection)this.db.getCollection(this.collection), (Class)this.beanType, String.class);
    }
}

