/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.batch.api.BatchProperty;
import javax.inject.Inject;
import javax.naming.InitialContext;
import org.jberet.support.io.ItemReaderWriterBase;
import org.jberet.support.io.MappingJsonFactoryObjectFactory;
import org.jberet.support.io.NoMappingJsonFactoryObjectFactory;

public abstract class JsonItemReaderWriterBase
extends ItemReaderWriterBase {
    @Inject
    @BatchProperty
    protected String jsonFactoryFeatures;
    @Inject
    @BatchProperty
    protected String mapperFeatures;
    @Inject
    @BatchProperty
    protected String jsonFactoryLookup;
    @Inject
    @BatchProperty
    protected String serializationFeatures;
    @Inject
    @BatchProperty
    protected String customSerializers;
    @Inject
    @BatchProperty
    protected String deserializationFeatures;
    @Inject
    @BatchProperty
    protected String customDeserializers;
    protected JsonFactory jsonFactory;
    protected ObjectMapper objectMapper;

    protected void registerModule() throws Exception {
        MappingJsonFactoryObjectFactory.configureCustomSerializersAndDeserializers(this.objectMapper, this.customSerializers, this.customDeserializers, this.getClass().getClassLoader());
    }

    protected void initJsonFactoryAndObjectMapper() throws Exception {
        this.jsonFactory = this.jsonFactoryLookup != null ? (JsonFactory)InitialContext.doLookup(this.jsonFactoryLookup) : new MappingJsonFactory();
        this.objectMapper = (ObjectMapper)this.jsonFactory.getCodec();
        if (this.jsonFactoryFeatures != null) {
            NoMappingJsonFactoryObjectFactory.configureJsonFactoryFeatures(this.jsonFactory, this.jsonFactoryFeatures);
        }
        if (this.mapperFeatures != null) {
            MappingJsonFactoryObjectFactory.configureMapperFeatures(this.objectMapper, this.mapperFeatures);
        }
        if (this.deserializationFeatures != null) {
            MappingJsonFactoryObjectFactory.configureDeserializationFeatures(this.objectMapper, this.deserializationFeatures);
        }
        if (this.serializationFeatures != null) {
            MappingJsonFactoryObjectFactory.configureSerializationFeatures(this.objectMapper, this.serializationFeatures);
        }
        this.registerModule();
    }
}

