/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.io.OutputDecorator;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemWriter;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.JsonItemReaderWriterBase;

@Named
@Dependent
public class JsonItemWriter
extends JsonItemReaderWriterBase
implements ItemWriter {
    @Inject
    @BatchProperty
    protected String writeMode;
    @Inject
    @BatchProperty
    protected Map<String, String> jsonGeneratorFeatures;
    @Inject
    @BatchProperty
    protected Class prettyPrinter;
    @Inject
    @BatchProperty
    protected Class outputDecorator;
    protected JsonGenerator jsonGenerator;

    public void open(Serializable checkpoint) throws Exception {
        SupportLogger.LOGGER.tracef("Open JsonItemWriter with checkpoint %s, which is ignored for JsonItemWriter.%n", checkpoint);
        this.initJsonFactoryAndObjectMapper();
        this.jsonGenerator = JsonItemWriter.configureJsonGenerator(this.jsonFactory, this.getOutputStream(this.writeMode), this.outputDecorator, this.jsonGeneratorFeatures);
        SupportLogger.LOGGER.openingResource(this.resource, this.getClass());
        if (this.prettyPrinter == null) {
            this.jsonGenerator.useDefaultPrettyPrinter();
        } else {
            this.jsonGenerator.setPrettyPrinter((PrettyPrinter)this.prettyPrinter.newInstance());
        }
        this.jsonGenerator.writeStartArray();
    }

    public void writeItems(List<Object> items) throws Exception {
        for (Object o : items) {
            this.jsonGenerator.writeObject(o);
        }
        this.jsonGenerator.flush();
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }

    public void close() throws Exception {
        if (this.jsonGenerator != null) {
            SupportLogger.LOGGER.closingResource(this.resource, this.getClass());
            this.jsonGenerator.close();
            this.jsonGenerator = null;
        }
    }

    protected static JsonGenerator configureJsonGenerator(JsonFactory jsonFactory, OutputStream outputStream, Class<?> outputDecorator, Map<String, String> jsonGeneratorFeatures) throws Exception {
        if (outputDecorator != null) {
            jsonFactory.setOutputDecorator((OutputDecorator)outputDecorator.newInstance());
        }
        JsonGenerator jsonGenerator = jsonFactory.createGenerator(outputStream);
        if (jsonGeneratorFeatures != null) {
            for (Map.Entry<String, String> e : jsonGeneratorFeatures.entrySet()) {
                JsonGenerator.Feature feature;
                String key = e.getKey();
                String value = e.getValue();
                try {
                    feature = JsonGenerator.Feature.valueOf((String)key);
                }
                catch (Exception e1) {
                    throw SupportMessages.MESSAGES.unrecognizedReaderWriterProperty(key, value);
                }
                if ("true".equals(value)) {
                    if (feature.enabledByDefault()) continue;
                    jsonGenerator.configure(feature, true);
                    continue;
                }
                if ("false".equals(value)) {
                    if (!feature.enabledByDefault()) continue;
                    jsonGenerator.configure(feature, false);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, value, key);
            }
        }
        return jsonGenerator;
    }
}

