/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.batch.api.BatchProperty;
import javax.batch.api.Batchlet;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperRunManager;
import net.sf.jasperreports.engine.data.JRAbstractTextDataSource;
import net.sf.jasperreports.engine.data.JRCsvDataSource;
import net.sf.jasperreports.engine.data.JRXlsxDataSource;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import net.sf.jasperreports.engine.data.JsonDataSource;
import net.sf.jasperreports.engine.data.XlsDataSource;
import net.sf.jasperreports.export.Exporter;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.SimpleExporterInput;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.ItemReaderWriterBase;

@Named
@Dependent
public class JasperReportsBatchlet
implements Batchlet {
    protected static final String DEFAULT_OUTPUT_TYPE = "pdf";
    @Inject
    @BatchProperty
    protected String resource;
    @Inject
    @BatchProperty
    protected String recordDelimiter;
    @Inject
    @BatchProperty
    protected String useFirstRowAsHeader;
    @Inject
    @BatchProperty
    protected String fieldDelimiter;
    @Inject
    @BatchProperty
    protected String[] columnNames;
    @Inject
    @BatchProperty
    protected String datePattern;
    @Inject
    @BatchProperty
    protected String numberPattern;
    @Inject
    @BatchProperty
    protected String timeZone;
    @Inject
    @BatchProperty
    protected String locale;
    @Inject
    @BatchProperty
    protected String charset;
    @Inject
    @BatchProperty
    protected String template;
    @Inject
    @BatchProperty
    protected String outputType;
    @Inject
    @BatchProperty
    protected String outputFile;
    @Inject
    @BatchProperty
    protected Map reportParameters;
    @Inject
    protected Instance<OutputStream> outputStreamInstance;
    @Inject
    protected Instance<JRDataSource> jrDataSourceInstance;
    @Inject
    protected Instance<Map<String, Object>> reportParametersInstance;
    @Inject
    protected Instance<Exporter> exporterInstance;
    private InputStream resourceInputStream;
    private String templateFilePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String process() throws Exception {
        InputStream templateInputStream = null;
        OutputStream outputStream = null;
        try {
            if (this.template == null || !this.template.toLowerCase().endsWith(".jasper")) {
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, this.template, "template (*.jasper)");
            }
            templateInputStream = this.getTemplateInputStream();
            outputStream = this.getOutputStream();
            String ftype = this.outputType == null ? DEFAULT_OUTPUT_TYPE : this.outputType.toLowerCase();
            JRDataSource jrDataSource = this.getJrDataSource();
            Map<String, Object> reportParameters1 = this.getReportParameters();
            Exporter exporter = this.getExporter();
            if (exporter != null) {
                this.fillAndExportReport(templateInputStream, reportParameters1, jrDataSource, exporter);
            } else if (ftype.equals(DEFAULT_OUTPUT_TYPE)) {
                JasperRunManager.runReportToPdfStream((InputStream)templateInputStream, (OutputStream)outputStream, reportParameters1, (JRDataSource)jrDataSource);
                outputStream.flush();
            } else if (ftype.equals("html")) {
                JasperRunManager.runReportToHtmlFile((String)this.getTemplateFilePath(templateInputStream), (String)this.outputFile, reportParameters1, (JRDataSource)jrDataSource);
            } else if (ftype.equals("jrprint")) {
                JasperFillManager.fillReportToFile((String)this.getTemplateFilePath(templateInputStream), (String)this.outputFile, reportParameters1, (JRDataSource)jrDataSource);
            } else {
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, this.outputFile, "outputFile");
            }
            String string = null;
            return string;
        }
        finally {
            if (templateInputStream != null) {
                try {
                    templateInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (this.resourceInputStream != null) {
                try {
                    this.resourceInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void stop() throws Exception {
    }

    protected InputStream getTemplateInputStream() {
        return ItemReaderWriterBase.getInputStream(this.template, false);
    }

    protected OutputStream getOutputStream() throws FileNotFoundException {
        if (this.outputFile != null) {
            return new FileOutputStream(this.outputFile);
        }
        if (this.outputStreamInstance != null && !this.outputStreamInstance.isUnsatisfied()) {
            return (OutputStream)this.outputStreamInstance.get();
        }
        return null;
    }

    protected Map<String, Object> getReportParameters() {
        if (this.reportParameters != null) {
            return this.reportParameters;
        }
        if (this.reportParametersInstance != null && !this.reportParametersInstance.isUnsatisfied()) {
            return (Map)this.reportParametersInstance.get();
        }
        return new HashMap<String, Object>();
    }

    protected JRDataSource getJrDataSource() throws IOException, JRException {
        if (this.resource != null) {
            String res = this.resource.toLowerCase();
            this.resourceInputStream = ItemReaderWriterBase.getInputStream(this.resource, false);
            if (res.endsWith(".csv")) {
                JRCsvDataSource csvDataSource = this.charset == null ? new JRCsvDataSource(this.resourceInputStream) : new JRCsvDataSource(this.resourceInputStream, this.charset);
                this.setCommonJRDataSourceProperties((JRAbstractTextDataSource)csvDataSource);
                if (this.useFirstRowAsHeader != null) {
                    csvDataSource.setUseFirstRowAsHeader(Boolean.parseBoolean(this.useFirstRowAsHeader));
                }
                if (this.recordDelimiter != null) {
                    csvDataSource.setRecordDelimiter(this.recordDelimiter);
                }
                if (this.fieldDelimiter != null) {
                    csvDataSource.setFieldDelimiter(this.fieldDelimiter.trim().charAt(0));
                }
                if (this.columnNames != null) {
                    csvDataSource.setColumnNames(this.columnNames);
                }
                return csvDataSource;
            }
            if (res.endsWith(".xls")) {
                XlsDataSource xlsDataSource = new XlsDataSource(this.resourceInputStream);
                this.setCommonJRDataSourceProperties((JRAbstractTextDataSource)xlsDataSource);
                if (this.columnNames != null) {
                    xlsDataSource.setColumnNames(this.columnNames);
                }
                if (this.useFirstRowAsHeader != null) {
                    xlsDataSource.setUseFirstRowAsHeader(Boolean.parseBoolean(this.useFirstRowAsHeader));
                }
                return xlsDataSource;
            }
            if (res.endsWith(".xlsx")) {
                JRXlsxDataSource jrXlsxDataSource = new JRXlsxDataSource(this.resourceInputStream);
                this.setCommonJRDataSourceProperties((JRAbstractTextDataSource)jrXlsxDataSource);
                if (this.columnNames != null) {
                    jrXlsxDataSource.setColumnNames(this.columnNames);
                }
                if (this.useFirstRowAsHeader != null) {
                    jrXlsxDataSource.setUseFirstRowAsHeader(Boolean.parseBoolean(this.useFirstRowAsHeader));
                }
                return jrXlsxDataSource;
            }
            if (res.endsWith(".xml")) {
                JRXmlDataSource jrXmlDataSource = new JRXmlDataSource(this.resourceInputStream);
                this.setCommonJRDataSourceProperties((JRAbstractTextDataSource)jrXmlDataSource);
                return jrXmlDataSource;
            }
            if (res.endsWith(".json")) {
                JsonDataSource jsonDataSource = new JsonDataSource(this.resourceInputStream);
                this.setCommonJRDataSourceProperties((JRAbstractTextDataSource)jsonDataSource);
                return jsonDataSource;
            }
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, this.resource, "resource");
        }
        if (this.jrDataSourceInstance != null && !this.jrDataSourceInstance.isUnsatisfied()) {
            return (JRDataSource)this.jrDataSourceInstance.get();
        }
        return new JREmptyDataSource();
    }

    protected Exporter getExporter() throws Exception {
        if (this.exporterInstance != null && !this.exporterInstance.isUnsatisfied()) {
            return (Exporter)this.exporterInstance.get();
        }
        return null;
    }

    protected void fillAndExportReport(InputStream templateInputStream, Map<String, Object> reportParameters, JRDataSource jrDataSource, Exporter exporter) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport((InputStream)templateInputStream, reportParameters, (JRDataSource)jrDataSource);
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        exporter.exportReport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTemplateFilePath(InputStream templateInputStream) throws IOException {
        if (this.templateFilePath != null) {
            return this.templateFilePath;
        }
        File templateAsFile = new File(this.template);
        if (templateAsFile.exists()) {
            this.templateFilePath = this.template;
            return this.templateFilePath;
        }
        byte[] buffer = new byte[102400];
        templateAsFile = File.createTempFile("jberet-support-JasperReportsBatchlet", String.valueOf(System.currentTimeMillis()));
        FileOutputStream out = null;
        try {
            int len;
            out = new FileOutputStream(templateAsFile);
            while ((len = templateInputStream.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.templateFilePath = templateAsFile.getPath();
        return this.templateFilePath;
    }

    private void setCommonJRDataSourceProperties(JRAbstractTextDataSource jrDataSource) {
        if (this.locale != null) {
            jrDataSource.setLocale(this.locale);
        }
        if (this.timeZone != null) {
            jrDataSource.setTimeZone(this.timeZone);
        }
        if (this.numberPattern != null) {
            jrDataSource.setNumberPattern(this.numberPattern);
        }
        if (this.datePattern != null) {
            jrDataSource.setDatePattern(this.datePattern);
        }
    }
}

