/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.batch.api.chunk.ItemReader;
import javax.enterprise.context.Dependent;
import javax.inject.Named;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.jberet.support.io.ExcelUserModelItemReader;
import org.jberet.support.io.ItemReaderWriterBase;

@Named
@Dependent
public class ExcelStreamingItemReader
extends ExcelUserModelItemReader
implements ItemReader {
    private static final String schemaRelationships = "http://schemas.openxmlformats.org/officeDocument/2006/relationships";
    protected Boolean r1c1;
    protected InputStream sheetInputStream;
    protected XMLStreamReader sheetStreamReader;
    protected SharedStringsTable sharedStringsTable;

    @Override
    public Object readItem() throws Exception {
        if (this.currentRowNum == this.end) {
            return null;
        }
        while (this.sheetStreamReader.hasNext()) {
            int event = this.sheetStreamReader.next();
            if (event != 1 || !"row".equals(this.sheetStreamReader.getLocalName())) continue;
            this.currentRowNum = Integer.parseInt(this.sheetStreamReader.getAttributeValue(null, "r")) - 1;
            HashMap<String, String> resultMap = new HashMap<String, String>();
            while (this.sheetStreamReader.hasNext()) {
                int event1 = this.sheetStreamReader.next();
                if (event1 == 1 && "c".equals(this.sheetStreamReader.getLocalName())) {
                    String columnLabel = this.getColumnLabel(this.sheetStreamReader.getAttributeValue(null, "r"));
                    if (this.headerMapping == null) {
                        this.initHeaderMapping();
                    }
                    String key = (String)this.headerMapping.get(columnLabel);
                    resultMap.put(key, this.getCellStringValue());
                    continue;
                }
                if (event1 != 2 || !"row".equals(this.sheetStreamReader.getLocalName())) continue;
                if (this.beanType == Map.class) {
                    return resultMap;
                }
                if (this.beanType == List.class) {
                    ArrayList<String> resultList = new ArrayList<String>();
                    for (String h : this.header) {
                        resultList.add((String)resultMap.get(h));
                    }
                    return resultList;
                }
                this.initJsonFactoryAndObjectMapper();
                Object readValue = this.objectMapper.convertValue(resultMap, this.beanType);
                if (!this.skipBeanValidation) {
                    ItemReaderWriterBase.validate(readValue);
                }
                return readValue;
            }
        }
        return null;
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.sheetStreamReader != null) {
            try {
                this.sheetStreamReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sheetStreamReader = null;
        }
        if (this.sheetInputStream != null) {
            try {
                this.sheetInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sheetInputStream = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initWorkbookAndSheet(int startRowNumber) throws Exception {
        InputStream workbookDataInputStream = null;
        XMLStreamReader workbookStreamReader = null;
        try {
            OPCPackage opcPackage = OPCPackage.open((InputStream)this.inputStream);
            XSSFReader xssfReader = new XSSFReader(opcPackage);
            workbookDataInputStream = xssfReader.getWorkbookData();
            XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
            workbookStreamReader = xmlInputFactory.createXMLStreamReader(workbookDataInputStream);
            this.sharedStringsTable = xssfReader.getSharedStringsTable();
            while (workbookStreamReader.hasNext()) {
                if (workbookStreamReader.next() != 1 || !"sheet".equals(workbookStreamReader.getLocalName())) continue;
                String shn = workbookStreamReader.getAttributeValue(null, "name");
                String shId = workbookStreamReader.getAttributeValue(null, "sheetId");
                if ((this.sheetName == null || !this.sheetName.equals(shn)) && (this.sheetName != null || !String.valueOf(this.sheetIndex + 1).equals(shId))) continue;
                String relationshipId = workbookStreamReader.getAttributeValue(schemaRelationships, "id");
                this.sheetInputStream = xssfReader.getSheet(relationshipId);
                this.sheetStreamReader = xmlInputFactory.createXMLStreamReader(this.sheetInputStream);
                break;
            }
        }
        finally {
            if (workbookDataInputStream != null) {
                try {
                    workbookDataInputStream.close();
                }
                catch (Exception opcPackage) {}
            }
            if (workbookStreamReader != null) {
                try {
                    workbookStreamReader.close();
                }
                catch (Exception opcPackage) {}
            }
        }
        if (this.header == null) {
            this.headerMapping = new HashMap();
            block12: while (this.sheetStreamReader.hasNext()) {
                if (this.sheetStreamReader.next() != 1 || !"row".equals(this.sheetStreamReader.getLocalName())) continue;
                int rowNum = Integer.parseInt(this.sheetStreamReader.getAttributeValue(null, "r"));
                if (this.headerRow + 1 != rowNum) continue;
                ArrayList<String> headerVals = new ArrayList<String>();
                while (this.sheetStreamReader.hasNext()) {
                    int event = this.sheetStreamReader.next();
                    if (event == 1 && "c".equals(this.sheetStreamReader.getLocalName())) {
                        String label = this.getColumnLabel(this.sheetStreamReader.getAttributeValue(null, "r"));
                        String value = this.getCellStringValue();
                        headerVals.add(value);
                        this.headerMapping.put(label, value);
                        continue;
                    }
                    if (event != 2 || !"row".equals(this.sheetStreamReader.getLocalName())) continue;
                    this.header = headerVals.toArray(new String[headerVals.size()]);
                    this.currentRowNum = rowNum - 1;
                    break block12;
                }
            }
        }
        while (this.currentRowNum < startRowNumber - 1 && this.sheetStreamReader.hasNext()) {
            if (this.sheetStreamReader.next() == 1 && "row".equals(this.sheetStreamReader.getLocalName())) {
                this.currentRowNum = Integer.parseInt(this.sheetStreamReader.getAttributeValue(null, "r")) - 1;
                continue;
            }
            if (this.sheetStreamReader.next() != 2 || !"row".equals(this.sheetStreamReader.getLocalName()) || this.currentRowNum < startRowNumber - 1) continue;
            break;
        }
    }

    private String getCellStringValue() throws Exception {
        String result = null;
        String cellType = this.sheetStreamReader.getAttributeValue(null, "t");
        while (this.sheetStreamReader.hasNext()) {
            int event = this.sheetStreamReader.next();
            if (event == 1 && "v".equals(this.sheetStreamReader.getLocalName())) {
                result = this.sheetStreamReader.getElementText();
                if (!"s".equals(cellType)) continue;
                int idx = Integer.parseInt(result);
                result = new XSSFRichTextString(this.sharedStringsTable.getEntryAt(idx)).toString();
                continue;
            }
            if (event == 1 && "t".equals(this.sheetStreamReader.getLocalName())) {
                result = this.sheetStreamReader.getElementText();
                continue;
            }
            if (event != 2 || !"c".equals(this.sheetStreamReader.getLocalName())) continue;
            break;
        }
        return result;
    }

    private String getColumnLabel(String cellPoint) {
        if (this.r1c1 == null) {
            char[] chars = cellPoint.toCharArray();
            this.r1c1 = chars[0] == 'R' && Character.isDigit(chars[1]);
            return this.getColumnLabel(cellPoint);
        }
        if (this.r1c1.booleanValue()) {
            return cellPoint.substring(cellPoint.indexOf(67) + 1);
        }
        for (int i = 0; i < cellPoint.length(); ++i) {
            if (!Character.isDigit(cellPoint.charAt(i))) continue;
            return cellPoint.substring(0, i);
        }
        return cellPoint;
    }

    private void initHeaderMapping() {
        if (this.r1c1.booleanValue()) {
            for (int index = 0; index < this.header.length; ++index) {
                this.headerMapping.put(String.valueOf(index + 1), this.header[index]);
            }
        } else {
            for (int index = 0; index < this.header.length; ++index) {
                this.headerMapping.put(ExcelStreamingItemReader.getColumnLabelByPosition(index), this.header[index]);
            }
        }
    }

    private static String getColumnLabelByPosition(long index) {
        char[] ret = new char[64];
        for (int i = 0; i < ret.length; ++i) {
            int digit = ret.length - i - 1;
            long test = index - ExcelStreamingItemReader.powerDown(i + 1);
            if (test < 0L) break;
            ret[digit] = ExcelStreamingItemReader.toChar(test / (long)Math.pow(26.0, i));
        }
        return new String(ret);
    }

    private static char toChar(long num) {
        return (char)(num % 26L + 65L);
    }

    private static long powerDown(int limit) {
        long acc = 0L;
        while (limit > 1) {
            acc = (long)((double)acc + Math.pow(26.0, limit-- - 1));
        }
        return acc;
    }
}

