/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TypeCodec;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemReader;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.CassandraReaderWriterBase;
import org.jberet.support.io.ItemReaderWriterBase;

@Named
@Dependent
public class CassandraItemReader
extends CassandraReaderWriterBase
implements ItemReader {
    @Inject
    @BatchProperty
    protected int start;
    @Inject
    @BatchProperty
    protected int end;
    @Inject
    @BatchProperty
    protected Integer fetchSize;
    @Inject
    @BatchProperty
    protected String[] columnMapping;
    @Inject
    @BatchProperty
    protected boolean skipBeanValidation;
    protected String[] columnLabels;
    protected Statement statement;
    protected ResultSet resultSet;
    protected Iterator<Row> rowIterator;
    protected ColumnDefinitions columnDefinitions;
    protected Map<String, PropertyDescriptor> propertyDescriptorMap;
    protected int currentRowNumber;

    public void open(Serializable checkpoint) throws Exception {
        int checkpointPosition;
        if (this.session == null) {
            this.initSession();
        }
        this.initBeanPropertyDescriptors();
        if (this.statement == null) {
            this.statement = new SimpleStatement(this.cql);
        }
        if (this.fetchSize != null) {
            this.statement.setFetchSize(this.fetchSize.intValue());
        }
        this.resultSet = this.session.execute(this.statement);
        this.rowIterator = this.resultSet.iterator();
        this.columnDefinitions = this.resultSet.getColumnDefinitions();
        if (this.columnMapping == null) {
            if (this.beanType != List.class) {
                int columnCount = this.columnDefinitions.size();
                this.columnLabels = new String[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    this.columnLabels[i] = this.columnDefinitions.getName(i);
                }
                this.columnMapping = this.columnLabels;
            }
        } else if (this.columnMapping.length != this.columnDefinitions.size()) {
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, Arrays.toString(this.columnMapping), "columnMapping");
        }
        if (this.start <= 0) {
            this.start = 1;
        }
        if (this.end == 0) {
            this.end = Integer.MAX_VALUE;
        }
        if (this.end < this.start) {
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, String.valueOf(this.end), "end");
        }
        int readyPosition = this.start - 1;
        if (checkpoint != null && (checkpointPosition = ((Integer)checkpoint).intValue()) > readyPosition) {
            readyPosition = checkpointPosition;
        }
        while (this.currentRowNumber < readyPosition && this.rowIterator.hasNext()) {
            this.rowIterator.next();
            ++this.currentRowNumber;
        }
    }

    public Object readItem() throws Exception {
        if (this.currentRowNumber >= this.end) {
            return null;
        }
        Cloneable result = null;
        if (this.rowIterator.hasNext()) {
            Row row = this.rowIterator.next();
            if (this.beanType == List.class) {
                ArrayList<Object> resultList = new ArrayList<Object>();
                int k = this.columnDefinitions.size();
                for (int i = 0; i < k; ++i) {
                    resultList.add(this.getColumnValue(row, i, null));
                }
                result = resultList;
            } else if (this.beanType == Map.class) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                for (int i = 0; i < this.columnMapping.length; ++i) {
                    resultMap.put(this.columnMapping[i], this.getColumnValue(row, i, null));
                }
                result = resultMap;
            } else if (this.beanType != null) {
                Object readValue = this.beanType.newInstance();
                for (int i = 0; i < this.columnMapping.length; ++i) {
                    PropertyDescriptor propertyDescriptor = this.propertyDescriptorMap.get(this.columnMapping[i]);
                    Object columnValue = this.getColumnValue(row, i, propertyDescriptor.getPropertyType());
                    if (columnValue == null) continue;
                    propertyDescriptor.getWriteMethod().invoke(readValue, columnValue);
                }
                if (!this.skipBeanValidation) {
                    ItemReaderWriterBase.validate(readValue);
                }
                result = readValue;
            } else {
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, null, "beanType");
            }
        }
        ++this.currentRowNumber;
        return result;
    }

    public Serializable checkpointInfo() throws Exception {
        return Integer.valueOf(this.currentRowNumber);
    }

    @Override
    protected void initBeanPropertyDescriptors() throws IntrospectionException {
        super.initBeanPropertyDescriptors();
        if (this.propertyDescriptors != null) {
            this.propertyDescriptorMap = new HashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor propertyDescriptor : this.propertyDescriptors) {
                String name = propertyDescriptor.getName();
                if (name.equals("class")) continue;
                this.propertyDescriptorMap.put(name, propertyDescriptor);
            }
        }
    }

    private Object getColumnValue(Row row, int position, Class<?> desiredType) {
        Object val;
        if (row.isNull(position)) {
            return null;
        }
        DataType columnDefinitionsType = this.columnDefinitions.getType(position);
        DataType.Name cqlType = columnDefinitionsType.getName();
        if (desiredType != null && this.customCodecList != null) {
            for (TypeCodec c : this.customCodecList) {
                if (!c.accepts(desiredType) || !c.accepts(columnDefinitionsType)) continue;
                return row.get(position, c);
            }
        }
        switch (cqlType) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                val = row.getString(position);
                break;
            }
            case INT: {
                val = row.getInt(position);
                break;
            }
            case BIGINT: 
            case COUNTER: 
            case TIME: {
                val = row.getLong(position);
                break;
            }
            case BOOLEAN: {
                val = row.getBool(position);
                break;
            }
            case DOUBLE: {
                val = row.getDouble(position);
                break;
            }
            case VARINT: {
                val = row.getVarint(position);
                break;
            }
            case TINYINT: {
                val = row.getByte(position);
                break;
            }
            case SMALLINT: {
                val = row.getShort(position);
                break;
            }
            case FLOAT: {
                val = Float.valueOf(row.getFloat(position));
                break;
            }
            case DECIMAL: {
                val = row.getDecimal(position);
                break;
            }
            case DATE: {
                LocalDate localDate = row.getDate(position);
                if (desiredType == Long.TYPE || desiredType == Long.class) {
                    val = localDate.getMillisSinceEpoch();
                    break;
                }
                if (desiredType == Date.class) {
                    val = new Date(localDate.getMillisSinceEpoch());
                    break;
                }
                val = localDate;
                break;
            }
            case TIMESTAMP: {
                Date date = row.getTimestamp(position);
                if (desiredType == Long.TYPE || desiredType == Long.class) {
                    val = date.getTime();
                    break;
                }
                val = date;
                break;
            }
            case UUID: 
            case TIMEUUID: {
                val = row.getUUID(position);
                break;
            }
            case BLOB: {
                val = row.getBytes(position);
                break;
            }
            case INET: {
                val = row.getInet(position);
                break;
            }
            case DURATION: {
                val = row.getObject(position);
                break;
            }
            case TUPLE: {
                val = row.getTupleValue(position);
                break;
            }
            case UDT: {
                val = row.getUDTValue(position);
                break;
            }
            case LIST: {
                val = row.getList(position, Object.class);
                break;
            }
            case MAP: {
                val = row.getMap(position, Object.class, Object.class);
                break;
            }
            case SET: {
                val = row.getSet(position, Object.class);
                break;
            }
            default: {
                SupportLogger.LOGGER.unsupportedDataType(cqlType.name());
                val = row.getObject(position);
            }
        }
        return val;
    }
}

