/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.batch.api.BatchProperty;
import javax.batch.runtime.context.JobContext;
import javax.inject.Inject;
import javax.naming.InitialContext;
import org.beanio.StreamFactory;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.ItemReaderWriterBase;

public abstract class BeanIOItemReaderWriterBase
extends ItemReaderWriterBase {
    @Inject
    @BatchProperty
    protected String streamName;
    @Inject
    @BatchProperty
    protected String streamMapping;
    @Inject
    @BatchProperty
    protected String streamFactoryLookup;
    @Inject
    @BatchProperty
    protected Map mappingProperties;
    @Inject
    @BatchProperty
    protected String charset;
    @Inject
    protected JobContext jobContext;
    StreamFactoryKey mappingFileKey;
    private static final WeakHashMap<StreamFactoryKey, StreamFactory> beanIOMappings = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static StreamFactory getStreamFactory(String streamFactoryLookup, StreamFactoryKey key, Map mappingProperties) throws Exception {
        if (streamFactoryLookup != null) {
            return (StreamFactory)InitialContext.doLookup(streamFactoryLookup);
        }
        WeakHashMap<StreamFactoryKey, StreamFactory> weakHashMap = beanIOMappings;
        synchronized (weakHashMap) {
            StreamFactory streamFactory = beanIOMappings.get(key);
            if (streamFactory != null) {
                return streamFactory;
            }
            InputStream mappingInputStream = BeanIOItemReaderWriterBase.getInputStream(key.mappingFile, false);
            if (mappingInputStream == null) {
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, null, "streamMapping");
            }
            streamFactory = StreamFactory.newInstance();
            try {
                if (mappingProperties == null) {
                    streamFactory.load(mappingInputStream);
                } else {
                    Properties p = new Properties();
                    p.putAll((Map<?, ?>)mappingProperties);
                    streamFactory.load(mappingInputStream, p);
                }
            }
            finally {
                try {
                    mappingInputStream.close();
                }
                catch (IOException ioe) {
                    SupportLogger.LOGGER.tracef(ioe, "exception while closing BeanIO mapping InputStream, mappingFile: %s", key.mappingFile);
                }
            }
            beanIOMappings.put(key, streamFactory);
            return streamFactory;
        }
    }

    static class StreamFactoryKey {
        private final JobContext jobContext;
        private final String mappingFile;

        StreamFactoryKey(JobContext jobContext, String mappingFile) {
            this.jobContext = jobContext;
            this.mappingFile = mappingFile;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("StreamFactoryKey{");
            sb.append("jobContext=").append(this.jobContext);
            sb.append(", mappingFile='").append(this.mappingFile).append('\'');
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StreamFactoryKey that = (StreamFactoryKey)o;
            if (this.jobContext != that.jobContext) {
                return false;
            }
            return this.mappingFile.equals(that.mappingFile);
        }

        public int hashCode() {
            int result = this.jobContext.hashCode();
            result = 31 * result + this.mappingFile.hashCode();
            return result;
        }
    }
}

