/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Duration;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemWriter;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jberet.support._private.SupportLogger;
import org.jberet.support.io.CassandraReaderWriterBase;

@Named
@Dependent
public class CassandraItemWriter
extends CassandraReaderWriterBase
implements ItemWriter {
    @Inject
    @BatchProperty
    protected String[] parameterNames;
    protected BatchStatement batchStatement = new BatchStatement();
    protected PreparedStatement preparedStatement;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeItems(List<Object> items) throws Exception {
        try {
            for (Object item : items) {
                this.batchStatement.add((Statement)this.mapParameters(item));
            }
            ResultSet resultSet = this.session.execute((Statement)this.batchStatement);
        }
        finally {
            this.batchStatement.clear();
        }
    }

    public void open(Serializable checkpoint) throws Exception {
        if (this.session == null) {
            this.initSession();
        }
        if (this.preparedStatement == null) {
            this.preparedStatement = this.session.prepare(this.cql);
        }
        this.initBeanPropertyDescriptors();
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }

    private BoundStatement mapParameters(Object item) throws Exception {
        BoundStatement boundStatement;
        if (item instanceof List) {
            List itemAsList = (List)item;
            int itemSize = itemAsList.size();
            int parameterCount = this.preparedStatement.getVariables().size();
            Object[] itemAsArray = new Object[parameterCount];
            for (int i = 0; i < parameterCount && i < itemSize; ++i) {
                itemAsArray[i] = itemAsList.get(i);
            }
            boundStatement = this.preparedStatement.bind(itemAsArray);
        } else {
            HashMap<String, Object> itemAsMap;
            if (item instanceof Map) {
                itemAsMap = (HashMap<String, Object>)item;
            } else {
                if (this.propertyDescriptors == null) {
                    this.propertyDescriptors = Introspector.getBeanInfo(item.getClass()).getPropertyDescriptors();
                }
                itemAsMap = new HashMap<String, Object>();
                for (PropertyDescriptor d : this.propertyDescriptors) {
                    String name = d.getName();
                    if (name.equals("class")) continue;
                    Object val = d.getReadMethod().invoke(item, new Object[0]);
                    itemAsMap.put(name, val);
                }
            }
            boundStatement = this.preparedStatement.bind();
            for (ColumnDefinitions.Definition cd : this.preparedStatement.getVariables()) {
                String name = cd.getName();
                Object val = itemAsMap.get(name);
                if (val == null && this.parameterNames != null) {
                    for (String n : this.parameterNames) {
                        if (!name.equalsIgnoreCase(n)) continue;
                        val = itemAsMap.get(n);
                        break;
                    }
                }
                if (val == null) {
                    SupportLogger.LOGGER.queryParameterNotBound(name, this.cql);
                    continue;
                }
                this.setParameter(boundStatement, cd.getType().getName(), name, val);
            }
        }
        return boundStatement;
    }

    private void setParameter(BoundStatement st, DataType.Name cqlType, String n, Object v) {
        switch (cqlType) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                st.setString(n, v.toString());
                break;
            }
            case INT: {
                if (v instanceof Integer) {
                    st.setInt(n, ((Integer)v).intValue());
                    break;
                }
                st.set(n, v, v.getClass());
                break;
            }
            case BIGINT: 
            case COUNTER: 
            case TIME: {
                if (v instanceof Long) {
                    st.setLong(n, ((Long)v).longValue());
                    break;
                }
                st.set(n, v, v.getClass());
                break;
            }
            case BOOLEAN: {
                if (v instanceof Boolean) {
                    st.setBool(n, ((Boolean)v).booleanValue());
                    break;
                }
                st.set(n, v, v.getClass());
                break;
            }
            case DOUBLE: {
                if (v instanceof Double) {
                    st.setDouble(n, ((Double)v).doubleValue());
                    break;
                }
                st.set(n, v, v.getClass());
                break;
            }
            case VARINT: {
                if (v instanceof BigInteger) {
                    st.setVarint(n, (BigInteger)v);
                    break;
                }
                st.set(n, v, v.getClass());
                break;
            }
            case TINYINT: {
                if (v instanceof Byte) {
                    st.setByte(n, ((Byte)v).byteValue());
                    break;
                }
                st.set(n, v, v.getClass());
                break;
            }
            case SMALLINT: {
                if (v instanceof Short) {
                    st.setShort(n, ((Short)v).shortValue());
                    break;
                }
                st.set(n, v, v.getClass());
                break;
            }
            case FLOAT: {
                if (v instanceof Float) {
                    st.setFloat(n, ((Float)v).floatValue());
                    break;
                }
                st.set(n, v, v.getClass());
                break;
            }
            case DECIMAL: {
                if (v instanceof BigDecimal) {
                    st.setDecimal(n, (BigDecimal)v);
                    break;
                }
                st.set(n, v, v.getClass());
                break;
            }
            case DATE: {
                if (v instanceof LocalDate) {
                    st.setDate(n, (LocalDate)v);
                    break;
                }
                if (v instanceof Date) {
                    long time = ((Date)v).getTime();
                    st.setDate(n, LocalDate.fromMillisSinceEpoch((long)time));
                    break;
                }
                if (v instanceof Long) {
                    st.setDate(n, LocalDate.fromMillisSinceEpoch((long)((Long)v)));
                    break;
                }
                st.set(n, v, v.getClass());
                break;
            }
            case TIMESTAMP: {
                if (v instanceof Date) {
                    st.setTimestamp(n, (Date)v);
                    break;
                }
                if (v instanceof Long) {
                    st.setTimestamp(n, new Date((Long)v));
                    break;
                }
                st.set(n, v, v.getClass());
                break;
            }
            case UUID: 
            case TIMEUUID: {
                if (v instanceof UUID) {
                    st.setUUID(n, (UUID)v);
                    break;
                }
                st.set(n, v, v.getClass());
                break;
            }
            case BLOB: {
                if (v instanceof ByteBuffer) {
                    st.setBytes(n, (ByteBuffer)v);
                    break;
                }
                st.set(n, v, v.getClass());
                break;
            }
            case INET: {
                if (v instanceof InetAddress) {
                    st.setInet(n, (InetAddress)v);
                    break;
                }
                st.set(n, v, v.getClass());
                break;
            }
            case DURATION: {
                if (v instanceof Duration) {
                    st.set(n, (Object)((Duration)v), Duration.class);
                    break;
                }
                st.set(n, v, v.getClass());
                break;
            }
            case TUPLE: {
                if (v instanceof TupleValue) {
                    st.setTupleValue(n, (TupleValue)v);
                    break;
                }
                st.set(n, v, v.getClass());
                break;
            }
            case UDT: {
                if (v instanceof UDTValue) {
                    st.setUDTValue(n, (UDTValue)v);
                    break;
                }
                st.set(n, v, v.getClass());
                break;
            }
            case LIST: {
                if (v instanceof List) {
                    st.setList(n, (List)v);
                    break;
                }
                st.set(n, v, v.getClass());
                break;
            }
            case MAP: {
                if (v instanceof Map) {
                    st.setMap(n, (Map)v);
                    break;
                }
                st.set(n, v, v.getClass());
                break;
            }
            case SET: {
                if (v instanceof Set) {
                    st.setSet(n, (Set)v);
                    break;
                }
                st.set(n, v, v.getClass());
                break;
            }
            default: {
                SupportLogger.LOGGER.unsupportedDataType(cqlType.name());
                st.set(n, v, v.getClass());
            }
        }
    }
}

