/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.NettyOptions;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.ThreadingOptions;
import com.datastax.driver.core.TimestampGenerator;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.policies.AddressTranslator;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.SpeculativeExecutionPolicy;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.batch.api.BatchProperty;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jberet.support._private.SupportLogger;

public abstract class CassandraReaderWriterBase {
    @Inject
    protected Instance<Cluster> clusterInstance;
    @Inject
    protected Instance<Session> sessionInstance;
    @Inject
    @BatchProperty
    protected String cql;
    @Inject
    @BatchProperty
    protected Class beanType;
    @Inject
    @BatchProperty
    protected List<String> contactPoints;
    @Inject
    @BatchProperty
    protected String keyspace;
    @Inject
    @BatchProperty
    protected String user;
    @Inject
    @BatchProperty
    protected String password;
    @Inject
    @BatchProperty
    protected Map<String, String> clusterProperties;
    @Inject
    @BatchProperty
    protected List<String> customCodecs;
    protected Cluster cluster;
    protected Session session;
    protected boolean sessionCreated;
    protected PropertyDescriptor[] propertyDescriptors;
    protected List<TypeCodec> customCodecList;

    protected void initSession() throws Exception {
        if (!this.sessionInstance.isUnsatisfied()) {
            this.session = (Session)this.sessionInstance.get();
        } else {
            if (!this.clusterInstance.isUnsatisfied()) {
                this.cluster = (Cluster)this.clusterInstance.get();
            } else {
                Cluster.Builder clusterBuilder = Cluster.builder();
                this.addContactPoints(clusterBuilder);
                if (this.clusterProperties != null) {
                    this.applyClusterProperties(clusterBuilder);
                    if (this.user != null && this.user.length() > 0) {
                        clusterBuilder.withCredentials(this.user, this.password == null ? "" : this.password);
                    }
                }
                this.cluster = clusterBuilder.build();
            }
            this.session = this.cluster.connect(this.keyspace);
            this.sessionCreated = true;
        }
        this.initCustomCodecs();
    }

    public void close() throws Exception {
        if (this.sessionCreated && this.session != null && !this.session.isClosed()) {
            this.session.close();
            this.session = null;
        }
    }

    protected void applyClusterProperties(Cluster.Builder clusterBuilder) throws Exception {
        for (Map.Entry<String, String> e : this.clusterProperties.entrySet()) {
            String k = e.getKey();
            if (k.equalsIgnoreCase("AddressTranslator")) {
                clusterBuilder.withAddressTranslator(CassandraReaderWriterBase.create(e.getValue(), AddressTranslator.class));
                continue;
            }
            if (k.equalsIgnoreCase("AuthProvider")) {
                clusterBuilder.withAuthProvider(CassandraReaderWriterBase.create(e.getValue(), AuthProvider.class));
                continue;
            }
            if (k.equalsIgnoreCase("ClusterName")) {
                clusterBuilder.withClusterName(e.getValue());
                continue;
            }
            if (k.equalsIgnoreCase("CodecRegistry")) {
                clusterBuilder.withCodecRegistry(CassandraReaderWriterBase.create(e.getValue(), CodecRegistry.class));
                continue;
            }
            if (k.equalsIgnoreCase("Compression")) {
                clusterBuilder.withCompression(ProtocolOptions.Compression.valueOf((String)e.getValue().toUpperCase(Locale.ENGLISH)));
                continue;
            }
            if (k.equalsIgnoreCase("user")) {
                if (this.user != null && this.user.length() != 0) continue;
                this.user = e.getValue();
                continue;
            }
            if (k.equalsIgnoreCase("password")) {
                if (this.password != null && this.password.length() != 0) continue;
                this.password = e.getValue();
                continue;
            }
            if (k.equalsIgnoreCase("InitialListeners")) {
                ArrayList<Host.StateListener> stateListeners = new ArrayList<Host.StateListener>();
                for (String s : e.getValue().split(":")) {
                    stateListeners.add(CassandraReaderWriterBase.create(s.trim(), Host.StateListener.class));
                }
                clusterBuilder.withInitialListeners(stateListeners);
                continue;
            }
            if (k.equalsIgnoreCase("LoadBalancingPolicy")) {
                clusterBuilder.withLoadBalancingPolicy(CassandraReaderWriterBase.create(e.getValue(), LoadBalancingPolicy.class));
                continue;
            }
            if (k.equalsIgnoreCase("MaxSchemaAgreementWaitSeconds")) {
                clusterBuilder.withMaxSchemaAgreementWaitSeconds(Integer.parseInt(e.getValue()));
                continue;
            }
            if (k.equalsIgnoreCase("NettyOptions")) {
                clusterBuilder.withNettyOptions(CassandraReaderWriterBase.create(e.getValue(), NettyOptions.class));
                continue;
            }
            if (k.equalsIgnoreCase("JMXReporting")) {
                if (!e.getValue().equalsIgnoreCase("false")) continue;
                clusterBuilder.withoutJMXReporting();
                continue;
            }
            if (k.equalsIgnoreCase("Metrics")) {
                if (!e.getValue().equalsIgnoreCase("false")) continue;
                clusterBuilder.withoutMetrics();
                continue;
            }
            if (k.equalsIgnoreCase("PoolingOptions")) {
                clusterBuilder.withPoolingOptions(CassandraReaderWriterBase.create(e.getValue(), PoolingOptions.class));
                continue;
            }
            if (k.equalsIgnoreCase("port")) {
                clusterBuilder.withPort(Integer.parseInt(e.getValue()));
                continue;
            }
            if (k.equalsIgnoreCase("ProtocolVersion")) {
                clusterBuilder.withProtocolVersion(ProtocolVersion.valueOf((String)e.getValue()));
                continue;
            }
            if (k.equalsIgnoreCase("QueryOptions")) {
                clusterBuilder.withQueryOptions(CassandraReaderWriterBase.create(e.getValue(), QueryOptions.class));
                continue;
            }
            if (k.equalsIgnoreCase("ReconnectionPolicy")) {
                clusterBuilder.withReconnectionPolicy(CassandraReaderWriterBase.create(e.getValue(), ReconnectionPolicy.class));
                continue;
            }
            if (k.equalsIgnoreCase("RetryPolicy")) {
                clusterBuilder.withRetryPolicy(CassandraReaderWriterBase.create(e.getValue(), RetryPolicy.class));
                continue;
            }
            if (k.equalsIgnoreCase("SocketOptions")) {
                clusterBuilder.withSocketOptions(CassandraReaderWriterBase.create(e.getValue(), SocketOptions.class));
                continue;
            }
            if (k.equalsIgnoreCase("SpeculativeExecutionPolicy")) {
                clusterBuilder.withSpeculativeExecutionPolicy(CassandraReaderWriterBase.create(e.getValue(), SpeculativeExecutionPolicy.class));
                continue;
            }
            if (k.equalsIgnoreCase("SSL")) {
                if (!e.getValue().equalsIgnoreCase("true")) continue;
                clusterBuilder.withSSL();
                continue;
            }
            if (k.equalsIgnoreCase("SSLOptions")) {
                clusterBuilder.withSSL(CassandraReaderWriterBase.create(e.getValue(), SSLOptions.class));
                continue;
            }
            if (k.equalsIgnoreCase("ThreadingOptions")) {
                clusterBuilder.withThreadingOptions(CassandraReaderWriterBase.create(e.getValue(), ThreadingOptions.class));
                continue;
            }
            if (k.equalsIgnoreCase("TimestampGenerator")) {
                clusterBuilder.withTimestampGenerator(CassandraReaderWriterBase.create(e.getValue(), TimestampGenerator.class));
                continue;
            }
            SupportLogger.LOGGER.ignoreProperties(k, e.getValue());
        }
    }

    protected void initBeanPropertyDescriptors() throws IntrospectionException {
        if (this.beanType != null && this.beanType != List.class && this.beanType != Map.class && this.propertyDescriptors == null) {
            this.propertyDescriptors = Introspector.getBeanInfo(this.beanType).getPropertyDescriptors();
        }
    }

    protected void initCustomCodecs() throws Exception {
        if (this.customCodecs != null) {
            this.customCodecList = new ArrayList<TypeCodec>();
            for (String s : this.customCodecs) {
                TypeCodec codec = CassandraReaderWriterBase.create(s, TypeCodec.class);
                this.customCodecList.add(codec);
                this.cluster.getConfiguration().getCodecRegistry().register(codec);
            }
        }
    }

    private void addContactPoints(Cluster.Builder clusterBuilder) {
        if (this.contactPoints != null) {
            for (String e : this.contactPoints) {
                int i = e.lastIndexOf(58);
                if (i >= 0) {
                    String addr = e.substring(0, i);
                    int port = Integer.parseInt(e.substring(i + 1));
                    clusterBuilder.addContactPointsWithPorts(new InetSocketAddress[]{new InetSocketAddress(addr, port)});
                    continue;
                }
                clusterBuilder.addContactPoint(e);
            }
        }
    }

    private static <T> T create(String className, Class<T> clazz) throws Exception {
        Class<?> aClass = CassandraReaderWriterBase.class.getClassLoader().loadClass(className);
        return (T)aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

