/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemReader;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.ExcelItemReaderWriterBase;
import org.jberet.support.io.ItemReaderWriterBase;

@Named
@Dependent
public class ExcelUserModelItemReader
extends ExcelItemReaderWriterBase
implements ItemReader {
    @Inject
    @BatchProperty
    protected int start;
    @Inject
    @BatchProperty
    protected int end;
    @Inject
    @BatchProperty
    protected int sheetIndex;
    @Inject
    @BatchProperty
    protected Integer headerRow;
    protected InputStream inputStream;
    protected FormulaEvaluator formulaEvaluator;
    protected Iterator<Row> rowIterator;
    protected int minColumnCount;
    protected Map<String, String> headerMapping;

    public void open(Serializable checkpoint) throws Exception {
        int startRowNumber;
        if (this.end == 0) {
            this.end = Integer.MAX_VALUE;
        }
        if (this.headerRow == null) {
            if (this.header == null) {
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, null, "header | headerRow");
            }
            this.headerRow = -1;
        }
        if (this.start == this.headerRow) {
            ++this.start;
        }
        int n = startRowNumber = checkpoint == null ? this.start : (Integer)checkpoint;
        if (startRowNumber < this.start || startRowNumber > this.end || startRowNumber < 0 || startRowNumber <= this.headerRow) {
            throw SupportMessages.MESSAGES.invalidStartPosition(startRowNumber, this.start, this.end);
        }
        this.inputStream = ExcelUserModelItemReader.getInputStream(this.resource, false);
        this.initWorkbookAndSheet(startRowNumber);
        if (this.header != null) {
            this.minColumnCount = this.header.length;
        }
    }

    public Object readItem() throws Exception {
        if (this.currentRowNum == this.end) {
            return null;
        }
        while (this.rowIterator.hasNext()) {
            Row row = this.rowIterator.next();
            this.currentRowNum = row.getRowNum();
            short lastCellNum = row.getLastCellNum();
            if (lastCellNum == -1) continue;
            int lastColumn = Math.max(lastCellNum, this.minColumnCount);
            if (List.class.isAssignableFrom(this.beanType)) {
                ArrayList<Object> resultList = new ArrayList<Object>();
                for (int cn = 0; cn < lastColumn; ++cn) {
                    Cell c = row.getCell(cn, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                    if (c == null) {
                        resultList.add(null);
                        continue;
                    }
                    resultList.add(this.getCellValue(c, c.getCellType()));
                }
                return resultList;
            }
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            for (int cn = 0; cn < this.header.length; ++cn) {
                Cell c = row.getCell(cn, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                if (c == null) continue;
                resultMap.put(this.header[cn], this.getCellValue(c, c.getCellType()));
            }
            if (Map.class.isAssignableFrom(this.beanType)) {
                return resultMap;
            }
            if (this.objectMapper == null) {
                this.initJsonFactoryAndObjectMapper();
            }
            Object readValue = this.objectMapper.convertValue(resultMap, this.beanType);
            if (!this.skipBeanValidation) {
                ItemReaderWriterBase.validate(readValue);
            }
            return readValue;
        }
        return null;
    }

    public Serializable checkpointInfo() throws Exception {
        return Integer.valueOf(this.currentRowNum);
    }

    public void close() throws Exception {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                SupportLogger.LOGGER.tracef(e, "Failed to close InputStream %s for resource %s", this.inputStream, this.resource);
            }
            this.inputStream = null;
        }
    }

    protected Object getCellValue(Cell c, CellType cellType) {
        Object cellValue;
        switch (cellType) {
            case STRING: {
                cellValue = c.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                cellValue = c.getBooleanCellValue();
                break;
            }
            case NUMERIC: {
                cellValue = DateUtil.isCellDateFormatted((Cell)c) ? c.getDateCellValue() : Double.valueOf(c.getNumericCellValue());
                break;
            }
            case BLANK: {
                cellValue = null;
                break;
            }
            case FORMULA: {
                if (this.formulaEvaluator == null) {
                    this.formulaEvaluator = this.workbook.getCreationHelper().createFormulaEvaluator();
                }
                this.formulaEvaluator.evaluateFormulaCell(c);
                cellValue = this.getCellValue(c, c.getCachedFormulaResultType());
                break;
            }
            default: {
                cellValue = c.getStringCellValue();
            }
        }
        return cellValue;
    }

    protected void initWorkbookAndSheet(int startRowNumber) throws Exception {
        this.workbook = WorkbookFactory.create((InputStream)this.inputStream);
        if (this.sheetName != null) {
            this.sheet = this.workbook.getSheet(this.sheetName);
        }
        if (this.sheet == null) {
            this.sheet = this.workbook.getSheetAt(this.sheetIndex);
        }
        startRowNumber = Math.max(startRowNumber, this.sheet.getFirstRowNum());
        this.rowIterator = this.sheet.rowIterator();
        if (startRowNumber > 0) {
            while (this.rowIterator.hasNext()) {
                Row row = this.rowIterator.next();
                this.currentRowNum = row.getRowNum();
                if (this.header == null && this.headerRow == this.currentRowNum) {
                    this.header = ExcelUserModelItemReader.getCellStringValues(row);
                }
                if (this.currentRowNum < startRowNumber - 1) continue;
                break;
            }
        }
    }
}

