/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.batch.api.BatchProperty;
import javax.batch.api.Batchlet;
import javax.batch.operations.BatchRuntimeException;
import javax.batch.runtime.context.StepContext;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.StreamHandler;

@Named
@Dependent
public class OsCommandBatchlet
implements Batchlet {
    @Inject
    protected StepContext stepContext;
    @Inject
    @BatchProperty
    protected String commandLine;
    @Inject
    @BatchProperty
    protected List<String> commandArray;
    @Inject
    @BatchProperty
    protected File workingDir;
    @Inject
    @BatchProperty
    protected int[] commandOkExitValues;
    @Inject
    @BatchProperty
    protected long timeoutSeconds;
    @Inject
    @BatchProperty
    protected Map<String, String> environment;
    @Inject
    @BatchProperty
    protected Class streamHandler;
    private final Object lock = new Object();
    private StreamHandler handler;
    private Process process;
    private boolean isStopped;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String process() throws Exception {
        File workingDirectory;
        ArrayList<String> cmd = new ArrayList<String>();
        if (this.commandLine != null) {
            cmd.addAll(OsCommandBatchlet.parse(this.commandLine));
        } else {
            if (this.commandArray == null) {
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, null, "commandArray");
            }
            if (this.commandArray.isEmpty()) {
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, this.commandArray.toString(), "commandArray");
            }
            cmd.addAll(this.commandArray);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        if (this.workingDir != null) {
            processBuilder.directory(this.workingDir);
        }
        if (this.environment != null) {
            processBuilder.environment().putAll(this.environment);
        }
        if ((workingDirectory = processBuilder.directory()) == null) {
            workingDirectory = new File(".");
        }
        if (!workingDirectory.exists()) {
            throw SupportMessages.MESSAGES.invalidDirectory(workingDirectory.getAbsolutePath());
        }
        SupportLogger.LOGGER.runCommand(cmd, workingDirectory.getAbsolutePath());
        Process process = processBuilder.start();
        StreamHandler handler = null;
        if (this.streamHandler != null) {
            handler = (StreamHandler)this.streamHandler.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            handler.setProcessErrorStream(process.getErrorStream());
            handler.setProcessInputStream(process.getOutputStream());
            handler.setProcessOutputStream(process.getInputStream());
            handler.start();
        }
        Object object = this.lock;
        synchronized (object) {
            this.process = process;
            this.handler = handler;
        }
        try {
            int exitCode;
            if (this.timeoutSeconds > 0L && !process.waitFor(this.timeoutSeconds, TimeUnit.SECONDS)) {
                process.destroyForcibly();
            }
            if (this.isFailure(exitCode = process.waitFor()) || exitCode != 0) {
                boolean started;
                this.stepContext.setExitStatus(String.valueOf(exitCode));
                Object object2 = this.lock;
                synchronized (object2) {
                    started = !this.isStopped;
                }
                if (started) {
                    throw new BatchRuntimeException(SupportMessages.MESSAGES.processExecutionFailure(exitCode, cmd));
                }
                SupportLogger.LOGGER.warn(SupportMessages.MESSAGES.processExecutionFailure(exitCode, cmd));
            }
            String string = String.valueOf(exitCode);
            return string;
        }
        finally {
            if (handler != null) {
                handler.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.process != null) {
                    this.isStopped = true;
                    this.process.destroyForcibly();
                }
            }
            finally {
                this.process = null;
                if (this.handler != null) {
                    this.handler.stop();
                }
            }
        }
    }

    private boolean isFailure(int exitCode) {
        if (this.commandOkExitValues == null) {
            return false;
        }
        for (int okValue : this.commandOkExitValues) {
            if (okValue != exitCode) continue;
            return false;
        }
        return true;
    }

    private static Collection<String> parse(String cmd) {
        if (cmd == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arguments = new ArrayList<String>();
        boolean inDoubleQuote = false;
        boolean inSingleQuote = false;
        StringBuilder sb = new StringBuilder();
        for (char c : cmd.toCharArray()) {
            if (c == '\"') {
                inDoubleQuote = !inSingleQuote && !inDoubleQuote;
            } else if (c == '\'') {
                inSingleQuote = !inSingleQuote && !inDoubleQuote;
            } else if (c == ' ' && !inDoubleQuote && !inSingleQuote) {
                arguments.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        if (inDoubleQuote || inSingleQuote) {
            throw new IllegalArgumentException("Missing trailing quote in: " + cmd);
        }
        if (sb.length() > 0) {
            arguments.add(sb.toString());
        }
        return arguments;
    }
}

