/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemReader;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.jberet.support._private.SupportLogger;
import org.jberet.support.io.ArtemisItemReaderWriterBase;
import org.jberet.support.io.ItemReaderWriterBase;

@Named
@Dependent
public class ArtemisItemReader
extends ArtemisItemReaderWriterBase
implements ItemReader {
    @Inject
    @BatchProperty
    protected long receiveTimeout;
    @Inject
    @BatchProperty
    protected Class beanType;
    protected ClientConsumer consumer;

    @Override
    public void open(Serializable checkpoint) throws Exception {
        super.open(checkpoint);
        this.consumer = this.session.createConsumer(this.queueName);
        this.session.start();
    }

    public Object readItem() throws Exception {
        Object result;
        ClientMessage message = this.consumer.receive(this.receiveTimeout);
        if (message == null) {
            return null;
        }
        int bodySize = message.getBodySize();
        if (bodySize == 0) {
            return null;
        }
        if (this.beanType == ClientMessage.class) {
            return message;
        }
        byte messageType = message.getType();
        byte[] bytes = new byte[bodySize];
        message.getBodyBuffer().readBytes(bytes);
        if (messageType == 3) {
            result = new String(bytes);
        } else {
            result = ArtemisItemReader.bytesToSerializableObject(bytes);
            if (!this.skipBeanValidation) {
                ItemReaderWriterBase.validate(result);
            }
        }
        return result;
    }

    @Override
    public void close() {
        super.close();
        if (this.consumer != null) {
            try {
                this.consumer.close();
            }
            catch (ActiveMQException e) {
                SupportLogger.LOGGER.tracef(e, "Failed to close Artemis consumer %s%n", this.consumer);
            }
            this.consumer = null;
        }
    }
}

