/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import jakarta.batch.api.BatchProperty;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.ItemReaderWriterBase;

public abstract class ArtemisItemReaderWriterBase
extends ItemReaderWriterBase {
    protected static final String QUEUE_NAME_KEY = "name";
    protected static final String QUEUE_ADDRESS_KEY = "address";
    protected static final String QUEUE_FILTER_KEY = "filter";
    protected static final String QUEUE_DURABLE_KEY = "durable";
    protected static final String QUEUE_SHARED_KEY = "shared";
    protected static final String QUEUE_TEMPORARY_KEY = "temporary";
    protected static final String SERVER_LOCATOR_HA_KEY = "HA";
    protected static final String NAME_KEY = "name";
    protected static final String FACTORY_CLASS_KEY = "factory-class";
    @Inject
    protected Instance<ServerLocator> serverLocatorInstance;
    @Inject
    protected Instance<ClientSessionFactory> sessionFactoryInstance;
    @Inject
    @BatchProperty
    protected Map connectorFactoryParams;
    @Inject
    @BatchProperty
    protected Map serverLocatorParams;
    @Inject
    @BatchProperty
    protected Map queueParams;
    @Inject
    @BatchProperty
    protected Class sendAcknowledgementHandler;
    protected SimpleString queueAddress;
    protected SimpleString queueName;
    protected ServerLocator serverLocator;
    protected ClientSessionFactory sessionFactory;
    protected ClientSession session;
    private boolean toCloseServerLocator;
    private boolean toCloseSessionFactory;

    public void open(Serializable checkpoint) throws Exception {
        if (this.queueParams == null) {
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, null, "queueParams");
        }
        this.queueAddress = SimpleString.toSimpleString((String)((String)this.queueParams.get(QUEUE_ADDRESS_KEY)));
        this.queueName = SimpleString.toSimpleString((String)((String)this.queueParams.get("name")));
        if (this.queueName == null) {
            this.queueName = this.queueAddress;
        }
        if (this.connectorFactoryParams != null) {
            String connectorFactoryName = (String)this.connectorFactoryParams.get("name");
            if (connectorFactoryName == null) {
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, this.connectorFactoryParams.toString(), "connectorFactoryParams");
            }
            this.connectorFactoryParams.remove("name");
            boolean withHA = false;
            if (this.serverLocatorParams != null && this.serverLocatorParams.containsKey(SERVER_LOCATOR_HA_KEY)) {
                withHA = Boolean.parseBoolean((String)this.serverLocatorParams.get(SERVER_LOCATOR_HA_KEY));
                if (this.serverLocatorParams.size() == 1) {
                    this.serverLocatorParams = null;
                } else {
                    this.serverLocatorParams.remove(SERVER_LOCATOR_HA_KEY);
                }
            }
            this.serverLocator = withHA ? (this.connectorFactoryParams == null ? ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(connectorFactoryName)}) : ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(connectorFactoryName, this.connectorFactoryParams)})) : (this.connectorFactoryParams == null ? ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(connectorFactoryName)}) : ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(connectorFactoryName, this.connectorFactoryParams)}));
            this.toCloseServerLocator = true;
        } else if (this.sessionFactoryInstance.isUnsatisfied()) {
            this.serverLocator = (ServerLocator)this.serverLocatorInstance.get();
        } else {
            this.sessionFactory = (ClientSessionFactory)this.sessionFactoryInstance.get();
        }
        if (this.serverLocatorParams != null && this.serverLocator != null) {
            this.configureServerLocator();
            this.sessionFactory = this.serverLocator.createSessionFactory();
            this.toCloseSessionFactory = true;
        }
        this.session = this.sessionFactory.createSession();
        if (this.sendAcknowledgementHandler != null) {
            this.session.setSendAcknowledgementHandler((SendAcknowledgementHandler)this.sendAcknowledgementHandler.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }

    protected void configureServerLocator() throws Exception {
        for (Object o : this.serverLocatorParams.keySet()) {
            String key = (String)o;
            String val = (String)this.serverLocatorParams.get(key);
            String setterName = "set" + Character.toUpperCase(key.charAt(0)) + key.substring(1);
            Method method = ServerLocator.class.getMethod(setterName, new Class[0]);
            Class<?> param1 = method.getParameterTypes()[0];
            Object[] args = new Object[1];
            if (param1 == Integer.TYPE) {
                args[0] = Integer.valueOf(val);
            } else if (param1 == String.class) {
                args[0] = val;
            } else if (param1 == Boolean.TYPE) {
                args[0] = Boolean.valueOf(val);
            } else if (param1 == Long.TYPE) {
                args[0] = Long.valueOf(val);
            } else if (param1 == Double.TYPE) {
                args[0] = Double.valueOf(val);
            }
            method.invoke((Object)this.serverLocator, args);
        }
    }

    protected void close() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (ActiveMQException e) {
                SupportLogger.LOGGER.tracef(e, "Failed to close Artemis client core session %s%n", this.session);
            }
            this.session = null;
        }
        if (this.sessionFactory != null && this.toCloseSessionFactory) {
            this.sessionFactory.close();
            this.sessionFactory = null;
        }
        if (this.serverLocator != null && this.toCloseServerLocator) {
            this.serverLocator.close();
            this.serverLocator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] objectToBytes(Object obj) throws IOException {
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(bos);
            out.writeObject(obj);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                bos.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Serializable bytesToSerializableObject(byte[] bytes) throws IOException, ClassNotFoundException {
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(bis);
            Serializable serializable = (Serializable)in.readObject();
            return serializable;
        }
        finally {
            try {
                bis.close();
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

