/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import jakarta.batch.api.BatchProperty;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.net.URI;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClient;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;

public class DynamoDbItemReadWriterBase<D> {
    @Inject
    protected Instance<DynamoDbClient> clientInstance;
    @Inject
    protected Instance<DynamoDbEnhancedClient> enhancedClientInstance;
    @Inject
    @BatchProperty
    protected String endpointUri;
    @Inject
    @BatchProperty
    protected String accessKeyId;
    @Inject
    @BatchProperty
    protected String secretAccessKey;
    @Inject
    @BatchProperty
    protected String region;
    protected DynamoDbClient client;
    protected DynamoDbEnhancedClient enhancedClient;
    @Inject
    @BatchProperty
    protected Class<D> beanClass;
    @Inject
    @BatchProperty
    protected String tableName;

    public DynamoDbTable<D> getTable() {
        return this.enhancedClient.table(this.tableName, (TableSchema)TableSchema.fromBean(this.beanClass));
    }

    protected void initEnhancedClient() {
        if (this.enhancedClient == null) {
            if (this.enhancedClientInstance == null || this.enhancedClientInstance.isUnsatisfied()) {
                this.initClient();
                this.enhancedClient = DynamoDbEnhancedClient.builder().dynamoDbClient(this.client).build();
            } else {
                this.enhancedClient = (DynamoDbEnhancedClient)this.enhancedClientInstance.get();
            }
        }
    }

    protected void initClient() {
        if (this.client == null) {
            if (this.clientInstance == null || this.clientInstance.isUnsatisfied()) {
                DynamoDbClientBuilder baseClientBuilder = DynamoDbClient.builder();
                if (this.endpointUri != null) {
                    baseClientBuilder = (DynamoDbClientBuilder)baseClientBuilder.endpointOverride(URI.create(this.endpointUri));
                }
                if (this.accessKeyId != null && this.secretAccessKey != null) {
                    baseClientBuilder = (DynamoDbClientBuilder)baseClientBuilder.credentialsProvider(this::awsBasicCredentials);
                }
                if (this.region != null) {
                    baseClientBuilder = (DynamoDbClientBuilder)baseClientBuilder.region(Region.of((String)this.region));
                }
                this.client = (DynamoDbClient)baseClientBuilder.build();
            } else {
                this.client = (DynamoDbClient)this.clientInstance.get();
            }
        }
    }

    private AwsBasicCredentials awsBasicCredentials() {
        return AwsBasicCredentials.create((String)this.accessKeyId, (String)this.secretAccessKey);
    }
}

