/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.Batchlet;
import jakarta.batch.runtime.BatchStatus;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jberet.support.io.DynamoDbItemReadWriterBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.model.CreateTableEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.EnhancedGlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoverySpecification;
import software.amazon.awssdk.services.dynamodb.model.ProjectionType;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.SSESpecification;
import software.amazon.awssdk.services.dynamodb.model.SSEType;
import software.amazon.awssdk.services.dynamodb.model.Tag;
import software.amazon.awssdk.services.dynamodb.model.TagResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableResponse;

@Named
@Dependent
public class DynamoDbTableBatchlet<D>
extends DynamoDbItemReadWriterBase<D>
implements Batchlet {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    @BatchProperty
    String action;
    @Inject
    @BatchProperty
    boolean dynamoDbLocal;
    @Inject
    @BatchProperty
    Long writeCapacityUnits;
    @Inject
    @BatchProperty
    Long readCapacityUnits;
    @Inject
    @BatchProperty
    List<String> globalSecondaryIndices;
    @Inject
    @BatchProperty
    String kmsMasterKeyId;
    @Inject
    @BatchProperty
    Boolean pointInTimeRecoveryEnabled;
    @Inject
    @BatchProperty
    Map<String, String> tableTags;

    private static <D> boolean tableExists(DynamoDbTable<D> table) {
        try {
            table.describeTable();
            return true;
        }
        catch (ResourceNotFoundException tableNotFoundExc) {
            return false;
        }
    }

    public void stop() throws Exception {
    }

    public String process() {
        if (this.action == null || this.action.isEmpty()) {
            return BatchStatus.COMPLETED.name();
        }
        this.initClient();
        this.initEnhancedClient();
        DynamoDbTable table = this.getTable();
        boolean tableExists = DynamoDbTableBatchlet.tableExists(table);
        switch (Action.valueOf(this.action.toUpperCase()).ordinal()) {
            case 0: {
                if (!tableExists) break;
                this.doDelete(table);
                break;
            }
            case 1: {
                if (!tableExists) {
                    this.doCreate(table);
                }
                this.doUpdate();
                break;
            }
            case 2: {
                if (!tableExists) break;
                this.doUpdate();
                break;
            }
            case 3: {
                if (tableExists) {
                    this.doDelete(table);
                }
                this.doCreate(table);
                this.doUpdate();
            }
        }
        return BatchStatus.COMPLETED.name();
    }

    private void doDelete(DynamoDbTable<D> table) {
        this.logger.warn("Deleting table {}", (Object)this.tableName);
        table.deleteTable();
        this.client.waiter().waitUntilTableNotExists((DescribeTableRequest)DescribeTableRequest.builder().tableName(this.tableName).build());
    }

    private void doCreate(DynamoDbTable<D> table) {
        this.logger.warn("Creating table {}", (Object)this.tableName);
        CreateTableEnhancedRequest.Builder createRequest = CreateTableEnhancedRequest.builder();
        if (this.globalSecondaryIndices != null && !this.globalSecondaryIndices.isEmpty()) {
            createRequest.globalSecondaryIndices((Collection)this.globalSecondaryIndices.stream().map(DynamoDbTableBatchlet::getEnhancedGlobalSecondaryIndex).collect(Collectors.toList()));
        }
        if (DynamoDbTableBatchlet.isValidCapacityUnits(this.writeCapacityUnits) && DynamoDbTableBatchlet.isValidCapacityUnits(this.readCapacityUnits)) {
            createRequest.provisionedThroughput(b -> b.writeCapacityUnits(this.writeCapacityUnits).readCapacityUnits(this.readCapacityUnits));
        }
        table.createTable(createRequest.build());
        this.client.waiter().waitUntilTableExists((DescribeTableRequest)DescribeTableRequest.builder().tableName(this.tableName).build());
    }

    private static boolean isValidCapacityUnits(Long capacityUnits) {
        return capacityUnits != null && capacityUnits > 0L;
    }

    private void doUpdate() {
        this.logger.warn("Updating table {}", (Object)this.tableName);
        String tableArn = null;
        if (this.kmsMasterKeyId != null && !this.kmsMasterKeyId.isEmpty()) {
            UpdateTableRequest.Builder updateRequest = UpdateTableRequest.builder().tableName(this.tableName);
            updateRequest = updateRequest.sseSpecification((SSESpecification)SSESpecification.builder().enabled(Boolean.valueOf(true)).sseType(SSEType.KMS).kmsMasterKeyId(this.kmsMasterKeyId).build());
            UpdateTableResponse updateResponse = this.client.updateTable((UpdateTableRequest)updateRequest.build());
            tableArn = updateResponse.tableDescription().tableArn();
        }
        if (this.tableTags != null && !this.tableTags.isEmpty() && !this.dynamoDbLocal) {
            if (tableArn == null) {
                DescribeTableResponse describeResponse = this.client.describeTable((DescribeTableRequest)DescribeTableRequest.builder().tableName(this.tableName).build());
                tableArn = describeResponse.table().tableArn();
            }
            List tags = this.tableTags.entrySet().stream().map(e -> (Tag)Tag.builder().key((String)e.getKey()).value((String)e.getValue()).build()).collect(Collectors.toList());
            this.client.tagResource((TagResourceRequest)TagResourceRequest.builder().resourceArn(tableArn).tags(tags).build());
        }
        if (this.pointInTimeRecoveryEnabled != null && !this.dynamoDbLocal) {
            this.client.updateContinuousBackups((UpdateContinuousBackupsRequest)UpdateContinuousBackupsRequest.builder().tableName(this.tableName).pointInTimeRecoverySpecification((PointInTimeRecoverySpecification)PointInTimeRecoverySpecification.builder().pointInTimeRecoveryEnabled(Boolean.valueOf(true)).build()).build());
        }
    }

    private static EnhancedGlobalSecondaryIndex getEnhancedGlobalSecondaryIndex(String indexName) {
        return EnhancedGlobalSecondaryIndex.builder().indexName(indexName).projection(pr -> pr.projectionType(ProjectionType.ALL)).build();
    }

    public static enum Action {
        DELETE,
        CREATE,
        UPDATE,
        TRUNCATE;

    }
}

