/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemWriter;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.ExcelItemReaderWriterBase;

@Named
@Dependent
public class ExcelUserModelItemWriter
extends ExcelItemReaderWriterBase
implements ItemWriter {
    @Inject
    @BatchProperty
    protected String writeMode;
    @Inject
    @BatchProperty
    protected String templateResource;
    @Inject
    @BatchProperty
    protected String templateSheetName;
    @Inject
    @BatchProperty
    protected int templateSheetIndex;
    @Inject
    @BatchProperty
    protected Integer templateHeaderRow;
    protected OutputStream outputStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(Serializable checkpoint) throws Exception {
        if (this.templateResource != null) {
            InputStream templateInputStream = null;
            try {
                templateInputStream = ExcelUserModelItemWriter.getInputStream(this.templateResource, false);
                Workbook templateWorkbook = this.createWorkbook(templateInputStream);
                if (this.templateSheetName != null) {
                    this.sheet = templateWorkbook.getSheet(this.templateSheetName);
                }
                if (this.sheet == null) {
                    this.sheet = templateWorkbook.getSheetAt(this.templateSheetIndex);
                }
                if (this.header == null) {
                    if (this.templateHeaderRow == null) {
                        throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, null, "templateHeaderRow");
                    }
                    Row headerRow = this.sheet.getRow(this.templateHeaderRow.intValue());
                    if (headerRow == null) {
                        throw SupportMessages.MESSAGES.failToReadExcelHeader(this.templateResource, this.templateSheetName);
                    }
                    this.header = ExcelUserModelItemWriter.getCellStringValues(headerRow);
                }
                this.currentRowNum = this.sheet.getLastRowNum();
                if (this.workbook != templateWorkbook) {
                    this.sheet = this.workbook.getSheet(this.sheet.getSheetName());
                }
                this.workbook.setActiveSheet(this.workbook.getSheetIndex(this.sheet));
            }
            finally {
                if (templateInputStream != null) {
                    try {
                        templateInputStream.close();
                    }
                    catch (Exception e) {
                        SupportLogger.LOGGER.tracef(e, "Failed to close template InputStream %s for template resource %s%n", templateInputStream, this.templateResource);
                    }
                }
            }
        }
        this.createWorkbook(null);
        Sheet sheet = this.sheet = this.sheetName == null ? this.workbook.createSheet() : this.workbook.createSheet(WorkbookUtil.createSafeSheetName((String)this.sheetName));
        if (this.header == null) {
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, null, "header");
        }
        Row headerRow = this.sheet.createRow(0);
        int j = this.header.length;
        for (int i = 0; i < j; ++i) {
            headerRow.createCell(i, CellType.STRING).setCellValue(this.header[i]);
        }
        this.currentRowNum = 0;
        this.outputStream = this.getOutputStream(this.writeMode);
    }

    public void writeItems(List<Object> items) throws Exception {
        int nextRowNum = this.currentRowNum + 1;
        Row row = null;
        if (List.class.isAssignableFrom(this.beanType)) {
            int i = 0;
            int j = items.size();
            while (i < j) {
                List item = (List)items.get(i);
                row = this.sheet.createRow(nextRowNum);
                int y = item.size();
                for (int x = 0; x < y; ++x) {
                    this.createCell(row, x, item.get(x));
                }
                ++i;
                ++nextRowNum;
            }
        } else if (Map.class.isAssignableFrom(this.beanType)) {
            int i = 0;
            int j = items.size();
            while (i < j) {
                Map item = (Map)items.get(i);
                row = this.sheet.createRow(nextRowNum);
                int y = this.header.length;
                for (int x = 0; x < y; ++x) {
                    this.createCell(row, x, item.get(this.header[x]));
                }
                ++i;
                ++nextRowNum;
            }
        } else {
            if (this.objectMapper == null) {
                this.initJsonFactoryAndObjectMapper();
            }
            int i = 0;
            int j = items.size();
            while (i < j) {
                Object item = items.get(i);
                Map itemAsMap = (Map)this.objectMapper.convertValue(item, Map.class);
                row = this.sheet.createRow(nextRowNum);
                int y = this.header.length;
                for (int x = 0; x < y; ++x) {
                    this.createCell(row, x, itemAsMap.get(this.header[x]));
                }
                ++i;
                ++nextRowNum;
            }
        }
        this.currentRowNum = row.getRowNum();
        if (this.sheet instanceof SXSSFSheet) {
            ((SXSSFSheet)this.sheet).flushRows();
        }
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }

    public void close() throws Exception {
        if (this.workbook != null) {
            if (this.outputStream != null) {
                try {
                    this.workbook.write(this.outputStream);
                }
                catch (IOException e) {
                    SupportLogger.LOGGER.failToWriteWorkbook(e, this.workbook.toString(), this.resource);
                }
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    SupportLogger.LOGGER.tracef(e, "Failed to close OutputStream %s for resource %s%n", this.outputStream, this.resource);
                }
                this.outputStream = null;
            }
            if (this.workbook instanceof SXSSFWorkbook) {
                ((SXSSFWorkbook)this.workbook).dispose();
            }
            this.workbook = null;
        }
    }

    protected Workbook createWorkbook(InputStream templateInputStream) throws IOException, InvalidFormatException {
        if (templateInputStream != null) {
            this.workbook = WorkbookFactory.create((InputStream)templateInputStream);
            return this.workbook;
        }
        this.workbook = this.resource.endsWith("xls") ? new HSSFWorkbook() : new XSSFWorkbook();
        return null;
    }

    protected void createCell(Row row, int columnIndex, Object val) throws Exception {
        if (val instanceof String) {
            Cell cell = row.createCell(columnIndex, CellType.STRING);
            cell.setCellValue((String)val);
        } else if (val instanceof Number) {
            Cell cell = row.createCell(columnIndex, CellType.NUMERIC);
            cell.setCellValue(((Number)val).doubleValue());
        } else if (val instanceof Boolean) {
            Cell cell = row.createCell(columnIndex, CellType.BOOLEAN);
            cell.setCellValue(((Boolean)val).booleanValue());
        } else if (val instanceof Character) {
            Cell cell = row.createCell(columnIndex, CellType.STRING);
            cell.setCellValue(val.toString());
        } else if (val == null) {
            row.createCell(columnIndex, CellType.BLANK);
        } else {
            Cell cell = row.createCell(columnIndex, CellType.STRING);
            cell.setCellValue(val.toString());
        }
    }
}

