/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.dataformat.csv.CsvGenerator;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemWriter;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.JacksonCsvItemReaderWriterBase;
import org.jberet.support.io.JsonItemWriter;

@Named
@Dependent
public class JacksonCsvItemWriter
extends JacksonCsvItemReaderWriterBase
implements ItemWriter {
    @Inject
    @BatchProperty
    protected String writeMode;
    @Inject
    @BatchProperty
    protected String lineSeparator;
    @Inject
    @BatchProperty
    protected Map<String, String> jsonGeneratorFeatures;
    @Inject
    @BatchProperty
    protected Map<String, String> csvGeneratorFeatures;
    @Inject
    @BatchProperty
    protected Class outputDecorator;
    protected CsvGenerator csvGenerator;

    public void writeItems(List<Object> items) throws Exception {
        for (Object o : items) {
            this.csvGenerator.writeObject(o);
        }
        this.csvGenerator.flush();
    }

    public void open(Serializable checkpoint) throws Exception {
        this.init();
        this.csvGenerator = (CsvGenerator)JsonItemWriter.configureJsonGenerator(this.jsonFactory, this.getOutputStream(this.writeMode), this.outputDecorator, this.jsonGeneratorFeatures);
        if (this.csvGeneratorFeatures != null) {
            for (Map.Entry<String, String> e : this.csvGeneratorFeatures.entrySet()) {
                CsvGenerator.Feature feature;
                String key = e.getKey();
                String value = e.getValue();
                try {
                    feature = CsvGenerator.Feature.valueOf((String)key);
                }
                catch (Exception e1) {
                    throw SupportMessages.MESSAGES.unrecognizedReaderWriterProperty(key, value);
                }
                if ("true".equals(value)) {
                    if (feature.enabledByDefault()) continue;
                    this.csvGenerator.configure(feature, true);
                    continue;
                }
                if ("false".equals(value)) {
                    if (!feature.enabledByDefault()) continue;
                    this.csvGenerator.configure(feature, false);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, value, key);
            }
        }
        if (this.columns != null) {
            CsvSchema schema = this.buildCsvSchema(null);
            if (this.lineSeparator != null) {
                schema = schema.withLineSeparator(this.lineSeparator);
            }
            this.csvGenerator.setSchema((FormatSchema)schema);
        }
    }

    public void close() throws Exception {
        if (this.csvGenerator != null) {
            SupportLogger.LOGGER.closingResource(this.resource, this.getClass());
            this.csvGenerator.close();
            this.csvGenerator = null;
        }
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }
}

