/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemReader;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.ItemReaderWriterBase;
import org.jberet.support.io.JmsItemReaderWriterBase;

@Named
@Dependent
public class JmsItemReader
extends JmsItemReaderWriterBase
implements ItemReader {
    @Inject
    @BatchProperty
    protected long receiveTimeout;
    @Inject
    @BatchProperty
    protected String messageSelector;
    @Inject
    @BatchProperty
    protected Class beanType;
    protected MessageConsumer consumer;

    @Override
    public void open(Serializable checkpoint) throws Exception {
        super.open(checkpoint);
        this.consumer = this.session.createConsumer(this.destination, this.messageSelector);
        this.connection.start();
    }

    public Object readItem() throws Exception {
        HashMap<String, Object> result;
        Message message = this.consumer.receive(this.receiveTimeout);
        if (message == null) {
            return null;
        }
        if (this.beanType == Message.class) {
            return message;
        }
        if (message instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage)message;
            result = objectMessage.getObject();
            if (!this.skipBeanValidation) {
                ItemReaderWriterBase.validate(result);
            }
        } else if (message instanceof MapMessage) {
            MapMessage mapMessage = (MapMessage)message;
            HashMap<String, Object> mapResult = new HashMap<String, Object>();
            Enumeration mapNames = mapMessage.getMapNames();
            if (mapNames != null) {
                while (mapNames.hasMoreElements()) {
                    String k = (String)mapNames.nextElement();
                    mapResult.put(k, mapMessage.getObject(k));
                }
            }
            result = mapResult;
        } else if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            result = textMessage.getText();
        } else {
            throw SupportMessages.MESSAGES.unexpectedJmsMessageType("ObjectMessage | MapMessage | TextMessage", message.getJMSType(), message.toString());
        }
        return result;
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }

    @Override
    public void close() {
        super.close();
        if (this.consumer != null) {
            try {
                this.consumer.close();
            }
            catch (JMSException e) {
                SupportLogger.LOGGER.tracef(e, "Failed to close JMS consumer %s%n", this.consumer);
            }
            this.consumer = null;
        }
    }
}

