/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemWriter;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.List;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.KafkaItemReaderWriterBase;

@Named
@Dependent
public class KafkaItemWriter
extends KafkaItemReaderWriterBase
implements ItemWriter {
    @Inject
    @BatchProperty
    protected String topicPartition;
    @Inject
    @BatchProperty
    protected String recordKey;
    protected KafkaProducer producer;
    private String topic;
    private Integer partition;

    public void open(Serializable checkpoint) throws Exception {
        this.producer = new KafkaProducer(this.createConfigProperties());
        if (this.topicPartition == null) {
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, null, "topicPartition");
        }
        int colonPos = this.topicPartition.lastIndexOf(58);
        if (colonPos > 0) {
            this.topic = this.topicPartition.substring(0, colonPos);
            this.partition = Integer.valueOf(this.topicPartition.substring(colonPos + 1));
        } else if (colonPos < 0) {
            this.topic = this.topicPartition;
        } else {
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, this.topicPartition, "topicPartition");
        }
    }

    public void writeItems(List<Object> items) throws Exception {
        for (Object item : items) {
            this.producer.send(new ProducerRecord(this.getTopic(item), this.getPartition(item), (Object)this.getRecordKey(item), item));
        }
    }

    public Serializable checkpointInfo() {
        return null;
    }

    public void close() {
        if (this.producer != null) {
            this.producer.close();
            this.producer = null;
        }
    }

    protected String getTopic(Object item) {
        return this.topic;
    }

    protected Integer getPartition(Object item) {
        return this.partition;
    }

    protected String getRecordKey(Object item) {
        return this.recordKey;
    }
}

