/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.InputDecorator;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemReader;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.ItemReaderWriterBase;
import org.jberet.support.io.XmlItemReaderWriterBase;

@Named
@Dependent
public class XmlItemReader
extends XmlItemReaderWriterBase
implements ItemReader {
    @Inject
    @BatchProperty
    protected Class beanType;
    @Inject
    @BatchProperty
    protected int start;
    @Inject
    @BatchProperty
    protected int end;
    @Inject
    @BatchProperty
    protected Class inputDecorator;
    @Inject
    @BatchProperty
    protected String xmlTextElementName;
    private FromXmlParser fromXmlParser;
    private JsonToken token;
    private int rowNumber;

    public void open(Serializable checkpoint) throws Exception {
        if (this.end == 0) {
            this.end = Integer.MAX_VALUE;
        }
        if (checkpoint != null) {
            this.start = (Integer)checkpoint;
        }
        if (this.start > this.end) {
            throw SupportMessages.MESSAGES.invalidStartPosition((Integer)checkpoint, this.start, this.end);
        }
        super.initXmlFactory();
        if (this.inputDecorator != null) {
            this.xmlFactory.setInputDecorator((InputDecorator)this.inputDecorator.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        this.fromXmlParser = (FromXmlParser)this.xmlFactory.createParser(XmlItemReader.getInputStream(this.resource, false));
        SupportLogger.LOGGER.openingResource(this.resource, this.getClass());
        this.token = this.fromXmlParser.nextToken();
    }

    public Object readItem() throws Exception {
        if (this.rowNumber >= this.end) {
            return null;
        }
        int nestedObjectLevel = 0;
        while (true) {
            this.token = this.fromXmlParser.nextToken();
            if (this.token == null) {
                return null;
            }
            if (this.token == JsonToken.START_OBJECT) {
                if (++nestedObjectLevel == 1) {
                    ++this.rowNumber;
                } else if (nestedObjectLevel < 1) {
                    throw SupportMessages.MESSAGES.unexpectedJsonContent(this.fromXmlParser.getCurrentLocation());
                }
                if (this.rowNumber < this.start) continue;
                break;
            }
            if (this.token != JsonToken.END_OBJECT) continue;
            --nestedObjectLevel;
        }
        Object readValue = this.xmlMapper.readValue((JsonParser)this.fromXmlParser, this.beanType);
        if (!this.skipBeanValidation) {
            ItemReaderWriterBase.validate(readValue);
        }
        return readValue;
    }

    public Serializable checkpointInfo() throws Exception {
        return Integer.valueOf(this.rowNumber);
    }

    public void close() throws Exception {
        if (this.fromXmlParser != null) {
            SupportLogger.LOGGER.closingResource(this.resource, this.getClass());
            this.fromXmlParser.close();
            this.fromXmlParser = null;
        }
    }

    @Override
    protected void initXmlModule() {
        if (this.xmlTextElementName != null && !this.xmlTextElementName.isEmpty()) {
            this.xmlModule = new JacksonXmlModule();
            this.xmlModule.setXMLTextElementName(this.xmlTextElementName);
        }
    }
}

