/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.vertx.cluster;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jberet.runtime.context.StepContextImpl;
import org.jberet.runtime.runner.StepExecutionRunner;
import org.jberet.spi.PartitionHandler;
import org.jberet.spi.PartitionHandlerFactory;
import org.jberet.vertx.cluster.VertxPartitionHandler;
import org.jberet.vertx.cluster._private.VertxClusterLogger;
import org.jberet.vertx.cluster._private.VertxClusterMessages;

public class VertxPartitionHandlerFactory
implements PartitionHandlerFactory {
    private Vertx vertx;
    private static final int clusterInitTimeout = 5;

    public VertxPartitionHandlerFactory() {
        Context context = Vertx.currentContext();
        if (context != null) {
            this.vertx = context.owner();
            if (!this.vertx.isClustered()) {
                throw VertxClusterMessages.MESSAGES.vertxNotClustered(this.vertx);
            }
        } else {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            Vertx.clusteredVertx((VertxOptions)new VertxOptions(), res -> {
                if (!res.succeeded()) {
                    throw VertxClusterMessages.MESSAGES.failToInitVertxCluster(res.cause());
                }
                this.vertx = (Vertx)res.result();
                countDownLatch.countDown();
            });
            try {
                if (!countDownLatch.await(5L, TimeUnit.MINUTES)) {
                    throw VertxClusterMessages.MESSAGES.failToInitVertxClusterTimeout(5L, TimeUnit.MINUTES);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            VertxClusterLogger.LOGGER.createdClusteredVertx(this.vertx);
        }
    }

    public PartitionHandler createPartitionHandler(StepContextImpl stepContext, StepExecutionRunner stepExecutionRunner) {
        return new VertxPartitionHandler(stepContext, this.vertx);
    }
}

