/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.vertx.cluster;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import java.io.Serializable;
import org.jberet.runtime.AbstractStepExecution;
import org.jberet.runtime.PartitionExecutionImpl;
import org.jberet.spi.PartitionInfo;
import org.jberet.spi.PartitionWorker;
import org.jberet.util.BatchUtil;
import org.jberet.vertx.cluster._private.VertxClusterLogger;

public class VertxPartitionWorker
implements PartitionWorker {
    private EventBus eventBus;

    public VertxPartitionWorker(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void reportData(Serializable data, AbstractStepExecution partitionExecution) throws Exception {
        byte[] bytes = BatchUtil.objectToBytes((Object)data);
        long stepExecutionId = partitionExecution.getStepExecutionId();
        this.eventBus.send(PartitionInfo.getCollectorQueueName((long)stepExecutionId), (Object)Buffer.buffer((byte[])bytes));
        VertxClusterLogger.LOGGER.sendCollectorData(stepExecutionId, ((PartitionExecutionImpl)partitionExecution).getPartitionId(), data);
    }

    public void partitionDone(AbstractStepExecution partitionExecution) throws Exception {
        this.reportData((Serializable)partitionExecution, partitionExecution);
    }
}

