/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.vertx.cluster;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import org.jberet.creation.ArtifactFactoryWrapper;
import org.jberet.job.model.Chunk;
import org.jberet.job.model.Step;
import org.jberet.operations.JobOperatorImpl;
import org.jberet.repository.JobRepository;
import org.jberet.runtime.AbstractStepExecution;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.PartitionExecutionImpl;
import org.jberet.runtime.context.AbstractContext;
import org.jberet.runtime.context.JobContextImpl;
import org.jberet.runtime.context.StepContextImpl;
import org.jberet.runtime.runner.BatchletRunner;
import org.jberet.runtime.runner.ChunkRunner;
import org.jberet.spi.ArtifactFactory;
import org.jberet.spi.BatchEnvironment;
import org.jberet.spi.JobTask;
import org.jberet.spi.PartitionInfo;
import org.jberet.spi.PartitionWorker;
import org.jberet.util.BatchUtil;
import org.jberet.vertx.cluster.VertxPartitionWorker;
import org.jberet.vertx.cluster._private.VertxClusterLogger;
import org.jberet.vertx.cluster._private.VertxClusterMessages;

public class PartitionVerticle
extends AbstractVerticle {
    public void start() throws Exception {
        JobOperatorImpl jobOperator = new JobOperatorImpl();
        final BatchEnvironment batchEnvironment = jobOperator.getBatchEnvironment();
        final JobRepository jobRepository = jobOperator.getJobRepository();
        final ArtifactFactoryWrapper artifactFactory = new ArtifactFactoryWrapper(batchEnvironment.getArtifactFactory());
        final EventBus eventBus = this.vertx.eventBus();
        Handler<Message<Buffer>> receivingPartitionHandler = new Handler<Message<Buffer>>(){

            public void handle(Message<Buffer> message) {
                PartitionInfo partitionInfo;
                Buffer body = (Buffer)message.body();
                byte[] bytes = body.getBytes();
                try {
                    partitionInfo = (PartitionInfo)BatchUtil.bytesToSerializableObject((byte[])bytes, (ClassLoader)batchEnvironment.getClassLoader());
                }
                catch (Exception e) {
                    throw VertxClusterMessages.MESSAGES.failedToReceivePartitionInfo(e);
                }
                final JobExecutionImpl jobExecution = partitionInfo.getJobExecution();
                final Step step = partitionInfo.getStep();
                final PartitionExecutionImpl partitionExecution = partitionInfo.getPartitionExecution();
                String stopRequestTopicName = PartitionInfo.getStopRequestTopicName((long)jobExecution.getExecutionId());
                eventBus.consumer(stopRequestTopicName, (Handler)new Handler<Message<Boolean>>(){

                    public void handle(Message<Boolean> stopMessage) {
                        VertxClusterLogger.LOGGER.receivedStopRequest(jobExecution.getExecutionId(), step.getId(), partitionExecution.getStepExecutionId(), partitionExecution.getPartitionId());
                        jobExecution.stop();
                    }
                });
                VertxClusterLogger.LOGGER.receivedPartitionInfo(partitionInfo);
                JobContextImpl jobContext = new JobContextImpl(jobExecution, null, (ArtifactFactory)artifactFactory, jobRepository, batchEnvironment);
                VertxPartitionWorker partitionWorker = new VertxPartitionWorker(eventBus);
                AbstractContext[] outerContext = new AbstractContext[]{jobContext};
                StepContextImpl stepContext = new StepContextImpl(step, (AbstractStepExecution)partitionExecution, outerContext);
                Chunk chunk = step.getChunk();
                Object runner = chunk == null ? new BatchletRunner(stepContext, null, step.getBatchlet(), (PartitionWorker)partitionWorker) : new ChunkRunner(stepContext, null, chunk, null, (PartitionWorker)partitionWorker);
                batchEnvironment.submitTask((JobTask)runner);
            }
        };
        eventBus.consumer("jberet.partition", (Handler)receivingPartitionHandler);
    }
}

