/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.wildfly.cluster.ejb;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Singleton;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.Topic;
import org.jberet.creation.ArtifactFactoryWrapper;
import org.jberet.operations.AbstractJobOperator;
import org.jberet.repository.JobRepository;
import org.jberet.spi.ArtifactFactory;
import org.jberet.spi.BatchEnvironment;
import org.jberet.spi.PartitionInfo;
import org.jberet.wildfly.cluster.jms.JmsPartitionResource;

@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@TransactionManagement(value=TransactionManagementType.BEAN)
public class PartitionSingletonBean {
    @Resource(name="jms/connectionFactory")
    private ConnectionFactory connectionFactory;
    @Resource(name="jms/stopRequestTopic")
    private Topic stopRequestTopic;
    @Resource(name="jms/partitionQueue")
    private Queue partitionQueue;
    private BatchEnvironment batchEnvironment;
    private JobRepository jobRepository;
    private ArtifactFactory artifactFactory;

    @PostConstruct
    private void postConstruct() {
        AbstractJobOperator jobOperator = JmsPartitionResource.getJobOperator();
        this.batchEnvironment = jobOperator.getBatchEnvironment();
        this.jobRepository = jobOperator.getJobRepository();
        this.artifactFactory = new ArtifactFactoryWrapper(this.batchEnvironment.getArtifactFactory());
    }

    public void runPartition(PartitionInfo partitionInfo) {
        JmsPartitionResource.runPartition((PartitionInfo)partitionInfo, (BatchEnvironment)this.batchEnvironment, (JobRepository)this.jobRepository, (ArtifactFactory)this.artifactFactory, (ConnectionFactory)this.connectionFactory, (Queue)this.partitionQueue, (Topic)this.stopRequestTopic);
    }
}

