/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.samples.wildfly.deserialization;

import java.io.Serializable;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.AbstractItemReader;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.jberet.samples.wildfly.deserialization.CheckpointInfo1;
import org.jberet.samples.wildfly.deserialization.Data1;

@Named
public class ItemReader1
extends AbstractItemReader {
    @Inject
    StepContext stepContext;
    @Inject
    @BatchProperty(name="fail.on")
    int failOn;
    @Inject
    @BatchProperty(name="number.limit")
    int numberLimit;
    int currentNumber;

    public Object readItem() throws Exception {
        if (++this.currentNumber >= this.numberLimit) {
            return null;
        }
        this.stepContext.setPersistentUserData((Serializable)new Data1("Current number: " + this.currentNumber));
        if (this.currentNumber == this.failOn) {
            throw new ArithmeticException("currentNumber matches fail.on number: " + this.currentNumber);
        }
        return this.currentNumber;
    }

    public Serializable checkpointInfo() throws Exception {
        return new CheckpointInfo1(this.currentNumber);
    }

    public void open(Serializable checkpoint) throws Exception {
        super.open(checkpoint);
        System.out.printf("Reader open with checkpoint %s%n", checkpoint);
        if (checkpoint != null) {
            this.currentNumber = ((CheckpointInfo1)checkpoint).getNumber();
        }
    }
}

