/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.google.calendar;

import com.google.api.services.calendar.Calendar;
import com.google.api.services.calendar.model.CalendarList;
import com.google.api.services.calendar.model.Event;
import com.google.api.services.calendar.model.Events;
import java.util.Map;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.google.calendar.AddCalendarWorkitemHandler;
import org.jbpm.process.workitem.google.calendar.AddEventWorkitemHandler;
import org.jbpm.process.workitem.google.calendar.GetCalendarsWorkitemHandler;
import org.jbpm.process.workitem.google.calendar.GetEventsWorkitemHandler;
import org.jbpm.process.workitem.google.calendar.GoogleCalendarAuth;
import org.jbpm.test.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class GoogleCalendarWorkitemHandlerTest
extends AbstractBaseTest {
    @Mock
    GoogleCalendarAuth auth;
    @Mock
    Calendar client;
    @Mock
    Calendar.Events clientEvents;
    @Mock
    Calendar.Calendars calendars;
    @Mock
    Calendar.CalendarList calendarsList;
    @Mock
    Calendar.CalendarList.List calendarsListList;
    @Mock
    Calendar.Calendars.Insert calendarsInsert;
    @Mock
    Calendar.Events.Insert calendarEventsInsert;
    @Mock
    Calendar.Events.List calendarEventsList;

    @Before
    public void setUp() {
        try {
            CalendarList calendarListModel = new CalendarList();
            Mockito.when((Object)this.client.calendars()).thenReturn((Object)this.calendars);
            Mockito.when((Object)this.calendars.insert((com.google.api.services.calendar.model.Calendar)Mockito.anyObject())).thenReturn((Object)this.calendarsInsert);
            Mockito.when((Object)this.calendarsInsert.execute()).thenReturn((Object)new com.google.api.services.calendar.model.Calendar());
            Mockito.when((Object)this.client.calendarList()).thenReturn((Object)this.calendarsList);
            Mockito.when((Object)this.calendarsList.list()).thenReturn((Object)this.calendarsListList);
            Mockito.when((Object)this.calendarsListList.execute()).thenReturn((Object)calendarListModel);
            Mockito.when((Object)this.auth.getAuthorizedCalendar(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.client);
            Mockito.when((Object)this.client.events()).thenReturn((Object)this.clientEvents);
            Mockito.when((Object)this.clientEvents.insert(Matchers.anyString(), (Event)Mockito.anyObject())).thenReturn((Object)this.calendarEventsInsert);
            Mockito.when((Object)this.calendarEventsInsert.execute()).thenReturn((Object)new Event());
            Mockito.when((Object)this.clientEvents.list(Matchers.anyString())).thenReturn((Object)this.calendarEventsList);
            Mockito.when((Object)this.calendarEventsList.execute()).thenReturn((Object)new Events());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAddCalendarHandler() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("CalendarSummary", (Object)"mycalendarsummary");
        AddCalendarWorkitemHandler handler = new AddCalendarWorkitemHandler("myAppName", "{}");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("Calendar") instanceof com.google.api.services.calendar.model.Calendar));
    }

    @Test(expected=WorkItemHandlerRuntimeException.class)
    public void testAddCalendarHandlerInvalidParams() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        AddCalendarWorkitemHandler handler = new AddCalendarWorkitemHandler("myAppName", "{}");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)0L, (long)manager.getResults().size());
    }

    @Test
    public void testAddEventHandler() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("CalendarSummary", (Object)"mycalendarsummary");
        workItem.setParameter("EventSummary", (Object)"myeventsummary");
        workItem.setParameter("EventStart", (Object)"Tue, 6 Aug 2017 01:19:39 +0530");
        workItem.setParameter("EventEnd", (Object)"Tue, 6 Aug 2017 06:19:39 +0530");
        workItem.setParameter("EventAttendees", (Object)"myeventattendees");
        workItem.setParameter("EventCreator", (Object)"myeventcreator");
        AddEventWorkitemHandler handler = new AddEventWorkitemHandler("myAppName", "{}");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("Event") instanceof Event));
    }

    @Test
    public void testGetCalendarsHandler() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        GetCalendarsWorkitemHandler handler = new GetCalendarsWorkitemHandler("myAppName", "{}");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("AllCalendars") instanceof CalendarList));
    }

    @Test
    public void testGetEventsHandler() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("CalendarSummary", (Object)"mycalendarsummary");
        GetEventsWorkitemHandler handler = new GetEventsWorkitemHandler("myAppName", "{}");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("AllEvents") instanceof Events));
    }
}

