/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.google.calendar;

import com.google.api.services.calendar.Calendar;
import com.google.api.services.calendar.model.CalendarList;
import java.text.MessageFormat;
import java.util.HashMap;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.google.calendar.GoogleCalendarAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="GoogleGetCalendarsDefinitions.wid", name="GoogleGetCalendars", displayName="GoogleGetCalendars", defaultHandler="mvel: new org.jbpm.process.workitem.google.calendar.GetCalendarsWorkitemHandler(\"appName\", \"clentSecret\")", documentation="google-calendar-workitem/index.html", category="google-calendar-workitem", icon="GoogleGetCalendars.png", results={@WidResult(name="AllCalendars", runtimeType="com.google.api.services.calendar.model.CalendarList")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="google-calendar-workitem", version="7.23.0.Final")}, serviceInfo=@WidService(category="Google Calendar", description="Add and retrieve Calendars and Calendar Events from Google", keywords="google,calendar,get,all", action=@WidAction(title="Get all existing Google Calendars"), authinfo=@WidAuth(required=true, params={"appName", "clentSecret"}, paramsdescription={"Google app name", "Google client secret"}, referencesite="https://developers.google.com/calendar/auth")))
public class GetCalendarsWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetCalendarsWorkitemHandler.class);
    private static final String RESULTS_ALL_CALENDARS = "AllCalendars";
    private String appName;
    private String clientSecret;
    private GoogleCalendarAuth auth = new GoogleCalendarAuth();

    public GetCalendarsWorkitemHandler(String appName, String clentSecret) {
        this.appName = appName;
        this.clientSecret = clentSecret;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        HashMap<String, CalendarList> results = new HashMap<String, CalendarList>();
        try {
            Calendar client = this.auth.getAuthorizedCalendar(this.appName, this.clientSecret);
            results.put(RESULTS_ALL_CALENDARS, this.getAllCalendars(client));
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public CalendarList getAllCalendars(Calendar client) {
        try {
            return (CalendarList)client.calendarList().list().execute();
        }
        catch (Exception e) {
            logger.error(MessageFormat.format("Error trying to get calendars: {0}.", e.getMessage()));
            return null;
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(GoogleCalendarAuth auth) {
        this.auth = auth;
    }
}

